/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_json;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kasuga.lib.core.client.model.anim_json.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeyFrame {
    public final String bone;
    public final HashMap<Float, Pose> position;
    public final HashMap<Float, Pose> rotation;
    public final HashMap<Float, Pose> scale;

    public KeyFrame(String bone, JsonObject json) {
        this.bone = bone;
        this.position = Maps.newHashMap();
        this.rotation = Maps.newHashMap();
        this.scale = Maps.newHashMap();
        this.deserializePosition(json);
        this.deserializeRotation(json);
        this.deserializeScale(json);
    }

    private void deserializeRotation(JsonObject object) {
        if (!object.has("rotation")) {
            return;
        }
        JsonElement element = object.get("rotation");
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            Pose pose = new Pose(0.0f, (JsonElement)array);
            this.rotation.put(Float.valueOf(0.0f), pose);
            return;
        }
        this.deserializeAndFillMaps(element.getAsJsonObject(), this.rotation);
    }

    private void deserializePosition(JsonObject object) {
        if (!object.has("position")) {
            return;
        }
        JsonElement element = object.get("position");
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            Pose pose = new Pose(0.0f, (JsonElement)array);
            this.position.put(Float.valueOf(0.0f), pose);
            return;
        }
        this.deserializeAndFillMaps(element.getAsJsonObject(), this.position);
    }

    private void deserializeScale(JsonObject object) {
        if (!object.has("scale")) {
            return;
        }
        JsonElement element = object.get("scale");
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            Pose pose = new Pose(0.0f, (JsonElement)array);
            this.scale.put(Float.valueOf(0.0f), pose);
            return;
        }
        this.deserializeAndFillMaps(element.getAsJsonObject(), this.scale);
    }

    private void deserializeAndFillMaps(JsonObject object, Map<Float, Pose> map) {
        object.entrySet().forEach(entry -> {
            float left = Float.parseFloat((String)entry.getKey());
            Pose pose = new Pose(left, (JsonElement)entry.getValue());
            map.put(Float.valueOf(left), pose);
        });
    }

    public List<Map.Entry<Float, Pose>> sortPositions() {
        return KeyFrame.sortMap(this.position);
    }

    public List<Map.Entry<Float, Pose>> sortRotations() {
        return KeyFrame.sortMap(this.rotation);
    }

    public List<Map.Entry<Float, Pose>> sortScale() {
        return KeyFrame.sortMap(this.scale);
    }

    public static List<Map.Entry<Float, Pose>> sortMap(Map<Float, Pose> map) {
        ArrayList<Map.Entry<Float, Pose>> result = new ArrayList<Map.Entry<Float, Pose>>(map.size());
        block0: for (Map.Entry<Float, Pose> entry : map.entrySet()) {
            float t = entry.getKey().floatValue();
            if (result.isEmpty()) {
                result.add(entry);
                continue;
            }
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(i).getKey().floatValue() > t) {
                    result.add(i, entry);
                    continue block0;
                }
                if (i != result.size() - 1) continue;
                result.add(entry);
                continue block0;
            }
        }
        return result;
    }
}

