/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import kasuga.lib.core.client.model.model_json.Geometry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Pose {
    public final float time;
    private final Vector3f pre;
    private final Vector3f post;
    private final boolean hasPre;
    public final String lerpMode;

    public Pose(float time, JsonElement element) {
        this.time = time;
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            this.post = Geometry.readVec3fFromJsonArray(array);
            this.pre = Vector3f.f_176763_.m_122281_();
            this.hasPre = false;
            this.lerpMode = null;
        } else if (element instanceof JsonObject) {
            JsonArray array;
            JsonElement jsonElement;
            JsonObject object = (JsonObject)element;
            if (object.has("post") && (jsonElement = object.get("post")) instanceof JsonArray) {
                array = (JsonArray)jsonElement;
                this.post = Geometry.readVec3fFromJsonArray(array);
            } else {
                this.post = Vector3f.f_176763_.m_122281_();
            }
            if (object.has("pre") && (jsonElement = object.get("pre")) instanceof JsonArray) {
                array = (JsonArray)jsonElement;
                this.pre = Geometry.readVec3fFromJsonArray(array);
            } else {
                this.pre = Vector3f.f_176763_.m_122281_();
            }
            this.hasPre = object.has("pre");
            this.lerpMode = object.has("lerp_mode") ? object.getAsJsonPrimitive("lerp_mode").getAsString() : null;
        } else {
            this.pre = Vector3f.f_176763_.m_122281_();
            this.post = Vector3f.f_176763_.m_122281_();
            this.hasPre = false;
            this.lerpMode = null;
        }
    }

    public String getLerpMode() {
        return this.lerpMode;
    }

    public boolean isCatmullRom() {
        return this.lerpMode != null && this.lerpMode.equals("catmullrom");
    }

    public float getTime() {
        return this.time;
    }

    public Vector3f getPost() {
        return this.post;
    }

    public Vector3f getPre() {
        return this.pre;
    }

    public boolean hasPre() {
        return this.hasPre;
    }
}

