/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kasuga.lib.core.client.model.BedrockRenderable;
import kasuga.lib.core.client.model.anim_model.AnimBone;
import kasuga.lib.core.client.model.anim_model.Animable;
import kasuga.lib.core.client.model.model_json.Bone;
import kasuga.lib.core.client.model.model_json.Cube;
import kasuga.lib.core.client.model.model_json.Geometry;
import kasuga.lib.core.client.render.SimpleColor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class AnimModel
implements Animable {
    public final Map<String, BedrockRenderable> children;
    public final List<BedrockRenderable> roots;
    public final Geometry geometry;
    public final Material material;
    public final RenderType renderType;
    private SimpleColor color;
    public Vector3f position;
    public Vector3f rotation;
    public Vector3f offset;
    public Vector3f animRot;
    public Vector3f scale;

    public AnimModel(Geometry geometry, Material material, RenderType renderType) {
        this.geometry = geometry;
        this.children = Maps.newHashMap();
        this.material = material;
        this.renderType = renderType;
        this.position = Cube.BASE_OFFSET.m_122281_();
        this.rotation = Vector3f.f_176763_.m_122281_();
        this.color = SimpleColor.fromRGBInt(0xFFFFFF);
        this.roots = Lists.newArrayList();
        this.collectChildren();
        this.initAnim();
    }

    protected AnimModel(Geometry geometry, Material material, RenderType renderType, Vector3f position, Vector3f rotation, SimpleColor color) {
        this.geometry = geometry;
        this.material = material;
        this.renderType = renderType;
        this.position = position.m_122281_();
        this.rotation = rotation.m_122281_();
        this.color = color.copy();
        this.children = Maps.newHashMap();
        this.roots = Lists.newArrayList();
        this.initAnim();
    }

    public AnimModel(Geometry geometry, Material material, RenderType renderType, Map<String, BedrockRenderable> children, List<BedrockRenderable> roots) {
        this.geometry = geometry;
        this.children = children;
        this.material = material;
        this.renderType = renderType;
        this.position = Vector3f.f_176763_.m_122281_();
        this.rotation = Vector3f.f_176763_.m_122281_();
        this.roots = roots;
        this.color = SimpleColor.fromRGBInt(0xFFFFFF);
        this.initAnim();
    }

    public void resetAnimation() {
        this.initAnim();
    }

    private void initAnim() {
        this.offset = Vector3f.f_176763_.m_122281_();
        this.animRot = Vector3f.f_176763_.m_122281_();
        this.scale = new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public void collectChildren() {
        this.geometry.getBones().forEach((name, bone) -> {
            AnimBone ab = new AnimBone((Bone)bone, this);
            this.children.put((String)name, ab);
        });
        this.dealWithDependency();
    }

    public void dealWithDependency() {
        this.children.forEach((name, ren) -> {
            if (!(ren instanceof AnimBone)) {
                return;
            }
            AnimBone ab = (AnimBone)ren;
            ab.addThisToParent();
        });
        this.children.forEach((name, ren) -> {
            if (!(ren instanceof AnimBone)) {
                return;
            }
            AnimBone b = (AnimBone)ren;
            if (b.bone.hasParent()) {
                return;
            }
            this.roots.add(b);
        });
    }

    public Map<String, BedrockRenderable> getChildrens() {
        return this.children;
    }

    public BedrockRenderable getChild(String name) {
        return this.children.getOrDefault(name, null);
    }

    public void applyTranslationAndRotation(PoseStack pose) {
        Vector3f translation = this.getRealPosition();
        pose.m_85837_((double)translation.m_122239_(), (double)translation.m_122260_(), (double)translation.m_122269_());
        Vector3f rotation = this.getRealRotation();
        if (rotation.equals((Object)Vector3f.f_176763_)) {
            return;
        }
        pose.m_85845_(Vector3f.f_122227_.m_122240_(rotation.m_122269_()));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(rotation.m_122260_()));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(rotation.m_122239_()));
        if (this.scale.equals((Object)Cube.BASE_SCALE)) {
            return;
        }
        pose.m_85841_(this.scale.m_122239_(), this.scale.m_122260_(), this.scale.m_122269_());
    }

    private Vector3f getRealPosition() {
        Vector3f result = this.position.m_122281_();
        result.m_122253_(this.offset);
        return result;
    }

    @Override
    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    private Vector3f getRealRotation() {
        Vector3f result = this.rotation.m_122281_();
        result.m_122253_(this.animRot);
        return result;
    }

    @Override
    public void setAnimRot(Vector3f animRot) {
        this.animRot = animRot;
    }

    @Override
    public void setScale(Vector3f scale) {
        this.scale = scale;
    }

    public SimpleColor getColor() {
        return this.color;
    }

    public void setColor(SimpleColor color) {
        this.color = color;
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        pose.m_85836_();
        this.applyTranslationAndRotation(pose);
        VertexConsumer consumer = buffer.m_6299_(this.renderType);
        this.roots.forEach(c -> c.render(pose, consumer, this.color, light, overlay));
        pose.m_85849_();
    }

    public void clearAnim() {
        this.initAnim();
        this.roots.forEach(b -> {
            if (!(b instanceof AnimBone)) {
                return;
            }
            AnimBone animBone = (AnimBone)b;
            animBone.recursionClearAnim();
        });
    }

    public void applyAnimation(HashMap<String, Triple<Vector3f, Vector3f, Vector3f>> multipliers) {
        this.children.forEach((name, r) -> {
            if (!(r instanceof AnimBone)) {
                return;
            }
            AnimBone animBone = (AnimBone)r;
            Triple multiplier = multipliers.getOrDefault(name, null);
            if (multiplier == null) {
                return;
            }
            animBone.setOffset((Vector3f)multiplier.getLeft());
            animBone.setAnimRot((Vector3f)multiplier.getMiddle());
            animBone.setScale((Vector3f)multiplier.getRight());
        });
    }

    public AnimModel copy() {
        return new AnimModel(this.geometry, this.material, this.renderType);
    }
}

