/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.model_json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import kasuga.lib.core.client.model.Rotationable;
import kasuga.lib.core.client.model.model_json.Cube;
import kasuga.lib.core.client.model.model_json.Geometry;
import kasuga.lib.core.client.model.model_json.Locator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

@OnlyIn(value=Dist.CLIENT)
public class Bone
implements Rotationable {
    public final String name;
    public final String parent;
    public final Vector3f pivot;
    public final Vector3f rotation;
    public final ArrayList<Cube> cubes;
    public final HashMap<String, Locator> locators;
    public final Geometry model;

    public Bone(JsonObject jsonObject, Geometry model) {
        this.model = model;
        this.name = jsonObject.get("name").getAsString();
        this.parent = jsonObject.has("parent") ? jsonObject.get("parent").getAsString() : null;
        JsonArray pivotJson = jsonObject.getAsJsonArray("pivot");
        this.pivot = new Vector3f(-pivotJson.get(0).getAsFloat(), pivotJson.get(1).getAsFloat(), pivotJson.get(2).getAsFloat());
        if (jsonObject.has("rotation")) {
            JsonArray rotationJson = jsonObject.getAsJsonArray("rotation");
            this.rotation = Geometry.readVec3fFromJsonArray(rotationJson);
        } else {
            this.rotation = new Vector3f();
        }
        this.locators = new HashMap();
        if (jsonObject.has("locators")) {
            JsonObject locatorJson = jsonObject.getAsJsonObject("locators").getAsJsonObject();
            locatorJson.entrySet().forEach(entry -> {
                JsonObject o;
                if (!((JsonElement)entry.getValue()).isJsonObject()) {
                    if (((JsonElement)entry.getValue()).isJsonArray()) {
                        Vector3f locatorPos = Geometry.readVec3fFromJsonArray(((JsonElement)entry.getValue()).getAsJsonArray());
                        locatorPos.m_122263_(-1.0f, 1.0f, 1.0f);
                        this.locators.put((String)entry.getKey(), new Locator(locatorPos, Vector3f.f_176763_.m_122281_()));
                    } else {
                        return;
                    }
                }
                Vector3f locatorPos = (o = ((JsonElement)entry.getValue()).getAsJsonObject()).has("offset") ? Geometry.readVec3fFromJsonArray(o.get("offset").getAsJsonArray()) : Vector3f.f_176763_.m_122281_();
                locatorPos.m_122263_(-1.0f, 1.0f, 1.0f);
                Vector3f locatorRot = o.has("rotation") ? Geometry.readVec3fFromJsonArray(o.get("rotation").getAsJsonArray()) : Vector3f.f_176763_.m_122281_();
                this.locators.put((String)entry.getKey(), new Locator(locatorPos, locatorRot));
            });
        }
        this.cubes = new ArrayList();
        if (!jsonObject.has("cubes")) {
            return;
        }
        JsonArray cubesJson = jsonObject.getAsJsonArray("cubes");
        for (JsonElement cubeJson : cubesJson) {
            Cube cube = new Cube(cubeJson.getAsJsonObject(), model, this);
            this.cubes.add(cube);
        }
    }

    public HashMap<String, Locator> getLocators() {
        return this.locators;
    }

    public ArrayList<Cube> getCubes() {
        return this.cubes;
    }

    @Override
    public Vector3f getPivot() {
        return this.pivot;
    }

    @Override
    public Vector3f getRotation() {
        return this.rotation;
    }

    public void addQuads(IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        this.cubes.forEach(cube -> cube.addQuads(owner, modelBuilder, bakery, spriteGetter, modelTransform, modelLocation));
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    @Nullable
    public Bone getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.model.getBone(this.parent);
    }

    public boolean isFlipV() {
        return this.model.isFlipV();
    }
}

