/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.model_json;

import com.mojang.math.Vector3f;
import java.util.HashMap;
import kasuga.lib.core.client.model.model_json.Cube;
import kasuga.lib.core.client.model.model_json.GeometryDescription;
import kasuga.lib.core.client.model.model_json.UnbakedUV;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoxLayerProcessor {
    private final boolean mirror;
    private final boolean visible;
    private final boolean emissive;
    private final boolean flipV;
    private final Vec2f textOffset;
    private final HashMap<Direction, Vec2f> faceAndSize;
    private final HashMap<Direction, Vec2f> positions;
    private final Vec2f textureSize;

    public BoxLayerProcessor(Cube cube, Vec2f textOffset, boolean flipV) {
        this.flipV = flipV;
        this.mirror = cube.mirror;
        this.visible = cube.visible;
        this.emissive = cube.emissive;
        this.textOffset = textOffset;
        this.faceAndSize = new HashMap();
        this.positions = new HashMap();
        for (Direction d : Direction.values()) {
            this.faceAndSize.put(d, BoxLayerProcessor.flatten(BoxLayerProcessor.getPositionPair(cube, d)));
        }
        this.generatePositions();
        GeometryDescription description = cube.getDescription();
        this.textureSize = new Vec2f(description.getTextureWidth(), description.getTextureHeight());
    }

    private void generatePositions() {
        float we_width = this.faceAndSize.get(Direction.WEST).x();
        float ud_width = this.faceAndSize.get(Direction.UP).x();
        float ud_height = this.faceAndSize.get(Direction.UP).y();
        float ns_width = this.faceAndSize.get(Direction.NORTH).x();
        this.positions.put(Direction.UP, this.textOffset.add(we_width, 0.0f));
        this.positions.put(Direction.DOWN, this.textOffset.add(we_width + ud_width, 0.0f));
        this.positions.put(Direction.NORTH, this.textOffset.add(we_width, ud_height));
        this.positions.put(Direction.SOUTH, this.textOffset.add(2.0f * we_width + ns_width, ud_height));
        this.positions.put(this.mirror ? Direction.WEST : Direction.EAST, this.textOffset.add(0.0f, ud_height));
        this.positions.put(this.mirror ? Direction.EAST : Direction.WEST, this.textOffset.add(we_width + ns_width, ud_height));
    }

    public UnbakedUV getUV(Direction direction) {
        boolean shouldMirror = this.mirror && direction != Direction.EAST && direction != Direction.WEST;
        return new UnbakedUV(direction, this.positions.get(direction), this.faceAndSize.get(direction), this.textureSize.x(), this.textureSize.y(), shouldMirror, this.flipV, this.visible, this.emissive);
    }

    public static Direction getSide(Cube cube, Vector3f pos1, Vector3f pos2) {
        Vector3f org = cube.getOrigin();
        Vector3f max = org.m_122281_();
        max.m_122253_(cube.getSize());
        if (pos1.m_122260_() == max.m_122260_() && pos2.m_122260_() == max.m_122260_()) {
            return Direction.UP;
        }
        if (pos1.m_122260_() == org.m_122260_() && pos2.m_122260_() == org.m_122260_()) {
            return Direction.DOWN;
        }
        if (pos1.m_122239_() == max.m_122239_() && pos2.m_122239_() == max.m_122239_()) {
            return Direction.EAST;
        }
        if (pos1.m_122239_() == org.m_122239_() && pos2.m_122239_() == org.m_122239_()) {
            return Direction.WEST;
        }
        if (pos1.m_122269_() == max.m_122269_() && pos2.m_122269_() == max.m_122269_()) {
            return Direction.SOUTH;
        }
        if (pos1.m_122269_() == org.m_122269_() && pos2.m_122269_() == org.m_122269_()) {
            return Direction.NORTH;
        }
        return null;
    }

    public static Direction getSide(Cube cube, Pair<Vector3f, Vector3f> pair) {
        return BoxLayerProcessor.getSide(cube, pair.getFirst(), pair.getSecond());
    }

    public static Pair<Vector3f, Vector3f> getPositionPair(Cube cube, Direction direction) {
        Vector3f org = cube.getOrigin();
        Vector3f max = org.m_122281_();
        max.m_122253_(cube.getSize());
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Pair.of(new Vector3f(org.m_122239_(), max.m_122260_(), org.m_122269_()), max.m_122281_());
            case Direction.DOWN -> Pair.of(org.m_122281_(), new Vector3f(max.m_122239_(), org.m_122260_(), max.m_122269_()));
            case Direction.EAST -> Pair.of(new Vector3f(max.m_122239_(), org.m_122260_(), org.m_122269_()), max.m_122281_());
            case Direction.WEST -> Pair.of(org.m_122281_(), new Vector3f(org.m_122239_(), max.m_122260_(), max.m_122269_()));
            case Direction.NORTH -> Pair.of(org.m_122281_(), new Vector3f(max.m_122239_(), max.m_122260_(), org.m_122269_()));
            case Direction.SOUTH -> Pair.of(new Vector3f(org.m_122239_(), org.m_122260_(), max.m_122269_()), max.m_122281_());
        };
    }

    public static Vec2f flatten(Vector3f pos1, Vector3f pos2) {
        if (pos1.m_122260_() - pos2.m_122260_() == 0.0f) {
            return new Vec2f(pos2.m_122239_() - pos1.m_122239_(), pos2.m_122269_() - pos1.m_122269_());
        }
        if (pos1.m_122269_() - pos2.m_122269_() == 0.0f) {
            return new Vec2f(pos2.m_122239_() - pos1.m_122239_(), pos2.m_122260_() - pos1.m_122260_());
        }
        if (pos1.m_122239_() - pos2.m_122239_() == 0.0f) {
            return new Vec2f(pos2.m_122269_() - pos1.m_122269_(), pos2.m_122260_() - pos1.m_122260_());
        }
        return Vec2f.ZERO;
    }

    public static Vec2f flatten(Pair<Vector3f, Vector3f> pair) {
        return BoxLayerProcessor.flatten(pair.getFirst(), pair.getSecond());
    }
}

