/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.model_json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import kasuga.lib.core.client.render.texture.Vec2f;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UnbakedUV {
    private final Direction direction;
    private final Vec2f uv;
    private final Vec2f uvSize;
    private final boolean mirrorX;
    private final boolean mirrorY;
    private final boolean visible;
    private final boolean emissive;

    public UnbakedUV(Direction direction, JsonObject json, float uvWidth, float uvHeight, boolean mirrorX, boolean mirrorY, boolean visible, boolean emissive) {
        this.direction = direction;
        this.mirrorX = mirrorX;
        this.mirrorY = mirrorY;
        this.visible = visible;
        this.emissive = emissive;
        JsonArray uvJson = json.getAsJsonArray("uv");
        this.uv = new Vec2f(uvJson.get(0).getAsFloat() / uvWidth, uvJson.get(1).getAsFloat() / uvHeight);
        JsonArray uvSizeJson = json.getAsJsonArray("uv_size");
        this.uvSize = new Vec2f(uvSizeJson.get(0).getAsFloat() / uvWidth, uvSizeJson.get(1).getAsFloat() / uvHeight);
        this.dealWithMirrors();
    }

    public UnbakedUV(Direction direction, Vec2f uv, Vec2f uvSize, float uvWidth, float uvHeight, boolean mirrorX, boolean mirrorY, boolean visible, boolean emissive) {
        this.direction = direction;
        this.mirrorX = mirrorX;
        this.mirrorY = mirrorY;
        this.visible = visible;
        this.emissive = emissive;
        this.uv = uv;
        this.uvSize = uvSize;
        this.dealWithMirrors();
    }

    private void dealWithMirrors() {
        float cache;
        if (this.mirrorX) {
            cache = this.uv.x() + this.uvSize.x();
            this.uvSize.setX(-this.uvSize.x());
            this.uv.setX(cache);
        }
        if (this.mirrorY) {
            cache = this.uv.y() + this.uvSize.y();
            this.uvSize.setY(this.uvSize.y());
            this.uv.setY(cache);
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Vec2f getUv() {
        return this.uv;
    }

    public Vec2f getUvSize() {
        return this.uvSize;
    }

    public boolean isMirrorX() {
        return this.mirrorX;
    }

    public boolean isMirrorY() {
        return this.mirrorY;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEmissive() {
        return this.emissive;
    }
}

