/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.model_json;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import kasuga.lib.core.client.model.model_json.Cube;
import kasuga.lib.core.client.model.model_json.UVCorner;
import kasuga.lib.core.client.model.model_json.UnbakedUV;
import kasuga.lib.core.client.render.texture.Vec2f;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Vertex {
    public final Vector3f position;
    public final Vec2f uv;

    public Vertex(Vector3f position, Vec2f uv) {
        this.position = position;
        this.uv = uv;
    }

    public Vertex(Cube cube, UnbakedUV uv, int index) {
        FaceInfo.VertexInfo vertexInfo = FaceInfo.m_108984_((Direction)uv.getDirection()).m_108982_(index);
        Vector3f org = cube.getOrigin().m_122281_();
        Vector3f max = cube.getSize().m_122281_();
        max.m_122253_(org);
        org.m_122272_(-cube.getInflate(), -cube.getInflate(), -cube.getInflate());
        max.m_122272_(cube.getInflate(), cube.getInflate(), cube.getInflate());
        float x = vertexInfo.f_108998_ == FaceInfo.Constants.f_108993_ ? max.m_122239_() : org.m_122239_();
        float y = vertexInfo.f_108999_ == FaceInfo.Constants.f_108992_ ? max.m_122260_() : org.m_122260_();
        float z = vertexInfo.f_109000_ == FaceInfo.Constants.f_108991_ ? max.m_122269_() : org.m_122269_();
        this.position = new Vector3f(x, y, z);
        Vec2f uvOrg = uv.getUv();
        Vec2f uvMax = uv.getUv().add(uv.getUvSize());
        UVCorner corner = UVCorner.getCorner(vertexInfo, uv.getDirection());
        float uvx = UVCorner.isLeft(corner) ? uvOrg.x() : uvMax.x();
        float uvy = UVCorner.isTop(corner) ? uvOrg.y() : uvMax.y();
        this.uv = new Vec2f(uvx, uvy);
    }

    public Vertex applyTranslation(Vector3f translate) {
        Vector3f result = this.position.m_122281_();
        result.m_122253_(translate);
        return new Vertex(result, this.uv);
    }

    public Vertex applyRotation(Vector3f pivot, Vector3f position, List<Quaternion> quaternions) {
        Vector3f result = this.position.m_122281_();
        result.m_122267_(pivot);
        quaternions.forEach(arg_0 -> ((Vector3f)result).m_122251_(arg_0));
        result.m_122253_(position);
        return new Vertex(result, this.uv);
    }

    public Vertex applyRotation(Vector3f pivot, Quaternion quaternion) {
        Vector3f result = this.position.m_122281_();
        result.m_122267_(pivot);
        result.m_122251_(quaternion);
        result.m_122253_(pivot);
        return new Vertex(result, this.uv);
    }

    public static boolean nearlyEquals(float num, float num2, float diff) {
        return num > num2 - diff && num < num2 + diff;
    }

    public Vertex applyScale(Vector3f pivot, Vector3f scale) {
        if (scale == null) {
            return this;
        }
        Vector3f result = this.position.m_122281_();
        result.m_122267_(pivot);
        result.m_122263_(scale.m_122239_(), scale.m_122260_(), scale.m_122269_());
        result.m_122253_(pivot);
        return new Vertex(result, this.uv);
    }

    public void fillVertex(int[] vertexData, int index, float u0, float v0, float scaleU, float scaleV) {
        int i = index * 8;
        vertexData[i] = Float.floatToRawIntBits(this.position.m_122239_());
        vertexData[i + 1] = Float.floatToRawIntBits(this.position.m_122260_());
        vertexData[i + 2] = Float.floatToRawIntBits(this.position.m_122269_());
        vertexData[i + 3] = -1;
        vertexData[i + 4] = Float.floatToRawIntBits(u0 + this.uv.x() * scaleU);
        vertexData[i + 5] = Float.floatToRawIntBits(v0 + this.uv.y() * scaleV);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vec2f getUv() {
        return this.uv;
    }
}

