/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.module.node;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import kasuga.lib.core.addons.node.NodePackage;
import kasuga.lib.core.addons.node.PackageReader;
import kasuga.lib.core.addons.node.PackageScanner;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.module.JavascriptModule;
import kasuga.lib.core.javascript.module.ModuleLoader;
import kasuga.lib.core.javascript.module.node.CommonJSUtils;
import kasuga.lib.core.javascript.module.node.JavascriptNodeModule;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Source;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Value;

public class CommonJSModuleLoader
implements ModuleLoader {
    WeakHashMap<JavascriptContext, HashMap<Pair<NodePackage, String>, JavascriptNodeModule>> moduleCache = new WeakHashMap();

    @Override
    public Optional<JavascriptModule> load(JavascriptModule source, String name) {
        if (name.contains(":")) {
            return Optional.empty();
        }
        List<Pair<NodePackage, String>> availableModuleNames = this.getModuleCandidate(source, name);
        if (availableModuleNames.isEmpty()) {
            return Optional.empty();
        }
        Optional<JavascriptModule> moduleLike = Optional.empty();
        for (Pair<NodePackage, String> moduleNameEntry : availableModuleNames) {
            NodePackage packageTarget = moduleNameEntry.getFirst();
            String realName = moduleNameEntry.getSecond();
            if (packageTarget == null || PackageScanner.splitPath(realName).isEmpty() && (realName = packageTarget.main) == null) continue;
            PackageReader reader = packageTarget.reader;
            moduleLike = CommonJSModuleLoader.first(List.of(realName, realName + ".js", realName + "/index.js"), reader::exists, path -> {
                Pair<NodePackage, String> cacheKey = Pair.of(packageTarget, path);
                if (this.moduleCache.containsKey(source.getContext()) && this.moduleCache.get(source.getContext()).containsKey(cacheKey)) {
                    return this.moduleCache.get(source.getContext()).get(cacheKey);
                }
                try {
                    if (!reader.isRegularFile((String)path) || reader.isDirectory((String)path)) {
                        return null;
                    }
                    List<String> splitedPath = PackageScanner.splitPath(path);
                    String dirName = PackageScanner.joinPath(splitedPath.subList(0, PackageScanner.splitPath(path).size() - 1));
                    String fileName = splitedPath.get(splitedPath.size() - 1);
                    InputStream stream = reader.open((String)path);
                    InputStreamReader streamReader = new InputStreamReader(stream);
                    Reader wrappedCommonJSModule = CommonJSUtils.transform(streamReader);
                    Source parsedSource = Source.newBuilder("js", wrappedCommonJSModule, packageTarget.packageName + "/" + path).buildLiteral();
                    Value moduleWrapper = source.getContext().execute(parsedSource);
                    JavascriptNodeModule module = new JavascriptNodeModule(source.getContext(), dirName, fileName, packageTarget, moduleWrapper);
                    this.moduleCache.computeIfAbsent(source.getContext(), key -> new HashMap()).put(cacheKey, module);
                    return module;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            });
            if (!moduleLike.isPresent()) continue;
            break;
        }
        return moduleLike;
    }

    public List<Pair<NodePackage, String>> getModuleCandidate(JavascriptModule source, String name) {
        ArrayList<Pair<NodePackage, String>> result = new ArrayList<Pair<NodePackage, String>>();
        if (source instanceof JavascriptNodeModule) {
            JavascriptNodeModule nodeModule = (JavascriptNodeModule)source;
            NodePackage nodePackage = nodeModule.getPackage();
            List<String> relative = PackageScanner.resolve(PackageScanner.splitPath(nodeModule.dirname), PackageScanner.splitPath(name));
            if (nodePackage != null) {
                result.add(Pair.of(nodePackage, PackageScanner.joinPath(relative)));
            }
        }
        List<Pair<NodePackage, String>> maybeModules = source.getContext().getScope().getPackage(name);
        result.addAll(maybeModules);
        return result;
    }

    public static Optional<JavascriptModule> first(List<String> maybeFiles, Predicate<String> predicate, Function<String, JavascriptNodeModule> reader) {
        for (String maybeFile : maybeFiles) {
            JavascriptNodeModule result;
            if (!predicate.test(maybeFile) || (result = reader.apply(maybeFile)) == null) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

