/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.prebuilt.websocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import kasuga.lib.core.javascript.prebuilt.websocket.WebsocketEvent;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.DefaultHttpHeaders;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.FullHttpResponse;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.HttpClientCodec;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.HttpObjectAggregator;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import kasuga.lib.vendor_modules.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;

public class WebsocketHandler
extends SimpleChannelInboundHandler<Object> {
    private final String url;
    private Channel channel;
    private WebSocketClientHandshaker handshaker;
    private EventLoopGroup eventLoopGroup;
    boolean isClosed = false;
    Set<Consumer<WebsocketEvent.CloseEvent>> onClose = new HashSet<Consumer<WebsocketEvent.CloseEvent>>();
    Set<Consumer<WebsocketEvent.OpenEvent>> onOpen = new HashSet<Consumer<WebsocketEvent.OpenEvent>>();
    Set<Consumer<WebsocketEvent.ErrorEvent>> onError = new HashSet<Consumer<WebsocketEvent.ErrorEvent>>();
    Set<Consumer<WebsocketEvent.MessageEvent>> onMessage = new HashSet<Consumer<WebsocketEvent.MessageEvent>>();

    WebsocketHandler(String url) {
        this.url = url;
        this.open();
    }

    private void open() {
        URI uri;
        try {
            uri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal URL", e);
        }
        String protocol = uri.getScheme().toLowerCase();
        if (!protocol.equals("ws") && !protocol.equals("wss")) {
            throw new IllegalArgumentException("Illegal URL: Invalid protocol " + protocol + ", expected ws or wss");
        }
        int port = uri.getPort();
        if (port == -1) {
            switch (protocol) {
                case "ws": {
                    port = 80;
                    break;
                }
                case "wss": {
                    port = 443;
                }
            }
        }
        SslContext ssl = null;
        try {
            if (protocol.equals("wss")) {
                ssl = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
        }
        catch (SSLException e) {
            throw new RuntimeException("Failed to build SSL context", e);
        }
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        this.eventLoopGroup = eventLoopGroup;
        Bootstrap bootstrap = new Bootstrap();
        final int finalPort = port;
        final String host = uri.getHost();
        final SslContext finalSsl = ssl;
        final WebsocketHandler that = this;
        ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (finalSsl != null) {
                    p.addLast(new ChannelHandler[]{finalSsl.newHandler(ch.alloc(), host, finalPort)});
                }
                p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, that});
            }
        });
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(uri, WebSocketVersion.V13, null, true, new DefaultHttpHeaders());
        this.channel = bootstrap.connect(host, port).channel();
        System.out.println("Websocket Mod Side Open successful");
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        System.out.println("Websocket Mod Channel Read");
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                this.handshaker.finishHandshake(this.channel, (FullHttpResponse)msg);
                System.out.println("WebSocket Client connected!");
                WebsocketHandler.dispatchEvent(this.onOpen, new WebsocketEvent.OpenEvent());
            }
            catch (WebSocketHandshakeException e) {
                System.out.println("WebSocket Client failed to connect");
            }
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ")");
        }
        WebSocketFrame frame = (WebSocketFrame)((Object)msg);
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            System.out.println("[WS Monitor] RX[TEXT]: " + textFrame.text());
            WebsocketHandler.dispatchEvent(this.onMessage, new WebsocketEvent.MessageEvent(textFrame.text()));
        } else if (frame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
            System.out.println("[WS Monitor] RX[Binary] ");
            WebsocketHandler.dispatchEvent(this.onMessage, new WebsocketEvent.MessageEvent(binaryFrame.content()));
        } else {
            if (frame instanceof PongWebSocketFrame) {
                return;
            }
            if (frame instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
                WebsocketHandler.dispatchEvent(this.onClose, new WebsocketEvent.CloseEvent(closeFrame.statusCode(), closeFrame.reasonText()));
                this.finalizeSocket();
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        System.out.println("WebSocket Client disconnected!");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
        WebsocketHandler.dispatchEvent(this.onError, new WebsocketEvent.ErrorEvent(cause.getMessage()));
        this.finalizeSocket();
    }

    protected static <T> void dispatchEvent(Set<Consumer<T>> consumers, T event) {
        for (Consumer<T> consumer : consumers) {
            consumer.accept(event);
        }
    }

    public void send(String string) {
        System.out.println("[WS Monitor] TX[TEXT]: " + string);
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(string));
    }

    public void send(ByteBuf buffer) {
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(buffer));
    }

    public void close() {
        this.channel.writeAndFlush((Object)new CloseWebSocketFrame());
    }

    public void finalizeSocket() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.channel.close();
        this.eventLoopGroup.shutdownGracefully();
        this.onOpen.clear();
        this.onError.clear();
        this.onClose.clear();
        this.onMessage.clear();
    }

    public void ping() {
        this.channel.write((Object)new PingWebSocketFrame(Unpooled.wrappedBuffer((byte[])new byte[]{8, 1, 8, 1})));
    }
}

