/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.packets.gui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kasuga.lib.core.network.S2CPacket;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Source;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class DevOpenScreenPacket
extends S2CPacket {
    static CloseableHttpClient client = HttpClients.createDefault();
    String bundle;
    String serverName;
    boolean isSecureConnection;

    public DevOpenScreenPacket(FriendlyByteBuf byteBuf) {
        super(byteBuf);
        CompoundTag tag = byteBuf.m_130260_();
        if (tag == null) {
            throw new IllegalStateException("Invalid packet");
        }
        this.serverName = tag.m_128461_("serverName");
        this.bundle = tag.m_128461_("bundle");
        this.isSecureConnection = tag.m_128471_("isSecureConnection");
    }

    public DevOpenScreenPacket(String bundle, String serverName, Boolean isSecureConnection) {
        this.bundle = bundle;
        this.serverName = serverName;
        this.isSecureConnection = isSecureConnection;
    }

    @Override
    public void handle(Minecraft minecraft) {
        InputStreamReader reader;
        HttpGet bundleAccessor = new HttpGet((this.isSecureConnection ? "https://" : "http://") + this.serverName + "/" + this.bundle + ".bundle?platform=minecraft&dev=true&inlineSourceMap=false&modulesOnly=false&runModule=true&hot=true");
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)bundleAccessor);
            InputStream stream = response.getEntity().getContent();
            reader = new InputStreamReader(stream);
        }
        catch (IOException e) {
            minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Failed to fetch"));
            return;
        }
        try {
            Source source = Source.newBuilder("js", reader, "bundled.js").build();
        }
        catch (IOException e) {
            minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to parse source:" + e.toString())));
            return;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("bundle", this.bundle);
        nbt.m_128359_("serverName", this.serverName);
        nbt.m_128379_("isSecureConnection", this.isSecureConnection);
        buf.m_130079_(nbt);
    }
}

