/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import com.mojang.datafixers.types.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.registrations.BlockEntityRendererBuilder;
import kasuga.lib.registrations.BundledReg;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockEntityReg<T extends BlockEntity>
extends Reg {
    private ArrayList<BlockProvider<?>> blockInvokerList = new ArrayList();
    private RegistryObject<BlockEntityType<T>> registryObject;
    private Type<?> dataType = null;
    private BlockEntityType.BlockEntitySupplier<T> builder;
    private Supplier<BlockEntityRendererBuilder<T>> rendererBuilder = null;
    private BiPredicate<ResourceLocation, Block> blockPredicate = null;

    public BlockEntityReg(String registrationKey) {
        super(registrationKey);
    }

    @Mandatory
    public BlockEntityReg<T> blockEntityType(BlockEntityType.BlockEntitySupplier blockEntity) {
        this.builder = blockEntity;
        return this;
    }

    @Optional
    public BlockEntityReg<T> withBlocks(BlockProvider<?> ... block) {
        this.blockInvokerList.addAll(List.of(block));
        return this;
    }

    @Optional
    public BlockEntityReg<T> blockPredicates(BiPredicate<ResourceLocation, Block> predicate) {
        this.blockPredicate = predicate;
        return this;
    }

    @Optional
    public BlockEntityReg<T> blockBundle(BundledReg<? extends BlockReg<?>> bundle) {
        for (BlockReg<?> blockReg : bundle.getElements().values()) {
            this.blockInvokerList.add(blockReg::getBlock);
        }
        return this;
    }

    @Optional
    public BlockEntityReg<T> addBlock(BlockProvider<?> block) {
        this.blockInvokerList.add(block);
        return this;
    }

    @Optional
    public BlockEntityReg<T> withRenderer(Supplier<BlockEntityRendererBuilder<T>> builder) {
        this.rendererBuilder = builder;
        return this;
    }

    @Optional
    public BlockEntityReg<T> dataType(Type<?> dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    @Mandatory
    public BlockEntityReg<T> submit(SimpleRegistry registry) {
        if (this.builder == null) {
            this.crashOnNotPresent(BlockEntityType.BlockEntitySupplier.class, "blockEntityType", "submit");
        }
        this.registryObject = registry.blockEntity().register(this.registrationKey, () -> BlockEntityType.Builder.m_155273_(this.builder, (Block[])this.getBlockList()).m_58966_(this.dataType));
        registry.cacheBeIn(this);
        return this;
    }

    public Block[] getBlockList() {
        LinkedList<Block> castBlockList = new LinkedList<Block>();
        if (this.blockPredicate != null) {
            for (Map.Entry entries : ForgeRegistries.BLOCKS.getEntries()) {
                if (!this.blockPredicate.test(((ResourceKey)entries.getKey()).m_135782_(), (Block)entries.getValue())) continue;
                castBlockList.add((Block)entries.getValue());
            }
        }
        Block[] result = new Block[this.blockInvokerList.size() + castBlockList.size()];
        int counter = 0;
        if (this.blockPredicate != null) {
            Iterator<Object> iterator = castBlockList.iterator();
            while (iterator.hasNext()) {
                Block block;
                result[counter] = block = (Block)iterator.next();
                ++counter;
            }
        }
        for (BlockProvider blockProvider : this.blockInvokerList) {
            result[counter] = blockProvider.provide();
            ++counter;
        }
        return result;
    }

    public Type<?> getData() {
        return this.dataType;
    }

    public BlockEntityRendererBuilder<T> getRendererBuilder() {
        return this.rendererBuilder.get();
    }

    public BlockEntityType<T> getType() {
        return this.registryObject == null ? null : (BlockEntityType)this.registryObject.get();
    }

    @Override
    public String getIdentifier() {
        return "block_entity";
    }

    @Inner
    public void registerRenderer(SimpleRegistry registry) {
        if (this.rendererBuilder != null) {
            registry.registerBlockEntityRenderer(() -> (BlockEntityType)this.registryObject.get(), this.rendererBuilder.get());
        }
    }

    public static interface BiPredicate<T, K> {
        public boolean test(T var1, K var2);
    }

    public static interface BlockProvider<T extends Block> {
        public T provide();
    }

    public static interface BlockEntityProvider<T extends BlockEntity> {
        public BlockEntityType<T> provide();
    }
}

