/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.ibm.icu.number;

import java.math.BigDecimal;
import java.math.MathContext;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.AffixPatternProvider;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.CustomSymbolCurrency;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.DecimalFormatProperties;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.Grouper;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.MacroProps;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.Padder;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.PatternStringParser;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.PatternStringUtils;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import kasuga.lib.vendor_modules.com.ibm.icu.impl.number.RoundingUtils;
import kasuga.lib.vendor_modules.com.ibm.icu.number.CompactNotation;
import kasuga.lib.vendor_modules.com.ibm.icu.number.CurrencyPrecision;
import kasuga.lib.vendor_modules.com.ibm.icu.number.FractionPrecision;
import kasuga.lib.vendor_modules.com.ibm.icu.number.IntegerWidth;
import kasuga.lib.vendor_modules.com.ibm.icu.number.Notation;
import kasuga.lib.vendor_modules.com.ibm.icu.number.NumberFormatter;
import kasuga.lib.vendor_modules.com.ibm.icu.number.Precision;
import kasuga.lib.vendor_modules.com.ibm.icu.number.ScientificNotation;
import kasuga.lib.vendor_modules.com.ibm.icu.number.UnlocalizedNumberFormatter;
import kasuga.lib.vendor_modules.com.ibm.icu.text.CompactDecimalFormat;
import kasuga.lib.vendor_modules.com.ibm.icu.text.DecimalFormatSymbols;
import kasuga.lib.vendor_modules.com.ibm.icu.text.PluralRules;
import kasuga.lib.vendor_modules.com.ibm.icu.util.Currency;
import kasuga.lib.vendor_modules.com.ibm.icu.util.ULocale;

final class NumberPropertyMapper {
    NumberPropertyMapper() {
    }

    public static UnlocalizedNumberFormatter create(DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        MacroProps macros = NumberPropertyMapper.oldToNew(properties, symbols, null);
        return (UnlocalizedNumberFormatter)NumberFormatter.with().macros(macros);
    }

    public static UnlocalizedNumberFormatter create(DecimalFormatProperties properties, DecimalFormatSymbols symbols, DecimalFormatProperties exportedProperties) {
        MacroProps macros = NumberPropertyMapper.oldToNew(properties, symbols, exportedProperties);
        return (UnlocalizedNumberFormatter)NumberFormatter.with().macros(macros);
    }

    public static UnlocalizedNumberFormatter create(String pattern, DecimalFormatSymbols symbols) {
        DecimalFormatProperties properties = PatternStringParser.parseToProperties(pattern);
        return NumberPropertyMapper.create(properties, symbols);
    }

    public static MacroProps oldToNew(DecimalFormatProperties properties, DecimalFormatSymbols symbols, DecimalFormatProperties exportedProperties) {
        boolean explicitMinMaxSig;
        boolean explicitCurrencyUsage;
        AffixPatternProvider affixProvider;
        MacroProps macros = new MacroProps();
        ULocale locale = symbols.getULocale();
        macros.symbols = symbols;
        PluralRules rules = properties.getPluralRules();
        if (rules == null && properties.getCurrencyPluralInfo() != null) {
            rules = properties.getCurrencyPluralInfo().getPluralRules();
        }
        macros.rules = rules;
        macros.affixProvider = affixProvider = PropertiesAffixPatternProvider.forProperties(properties);
        boolean useCurrency = properties.getCurrency() != null || properties.getCurrencyPluralInfo() != null || properties.getCurrencyUsage() != null || affixProvider.hasCurrencySign();
        Currency currency = CustomSymbolCurrency.resolve(properties.getCurrency(), locale, symbols);
        Currency.CurrencyUsage currencyUsage = properties.getCurrencyUsage();
        boolean bl = explicitCurrencyUsage = currencyUsage != null;
        if (!explicitCurrencyUsage) {
            currencyUsage = Currency.CurrencyUsage.STANDARD;
        }
        if (useCurrency) {
            macros.unit = currency;
        }
        int maxInt = properties.getMaximumIntegerDigits();
        int minInt = properties.getMinimumIntegerDigits();
        int maxFrac = properties.getMaximumFractionDigits();
        int minFrac = properties.getMinimumFractionDigits();
        int minSig = properties.getMinimumSignificantDigits();
        int maxSig = properties.getMaximumSignificantDigits();
        BigDecimal roundingIncrement = properties.getRoundingIncrement();
        MathContext mathContext = RoundingUtils.getMathContextOrUnlimited(properties);
        boolean explicitMinMaxFrac = minFrac != -1 || maxFrac != -1;
        boolean bl2 = explicitMinMaxSig = minSig != -1 || maxSig != -1;
        if (useCurrency) {
            if (minFrac == -1 && maxFrac == -1) {
                minFrac = currency.getDefaultFractionDigits(currencyUsage);
                maxFrac = currency.getDefaultFractionDigits(currencyUsage);
            } else if (minFrac == -1) {
                minFrac = Math.min(maxFrac, currency.getDefaultFractionDigits(currencyUsage));
            } else if (maxFrac == -1) {
                maxFrac = Math.max(minFrac, currency.getDefaultFractionDigits(currencyUsage));
            }
        }
        if (minInt == 0 && maxFrac != 0) {
            int n = minFrac = minFrac < 0 || minFrac == 0 && maxInt == 0 ? 1 : minFrac;
            maxFrac = maxFrac < 0 ? -1 : (maxFrac < minFrac ? minFrac : maxFrac);
            minInt = 0;
            maxInt = maxInt < 0 ? -1 : (maxInt > 999 ? -1 : maxInt);
        } else {
            int n = minFrac = minFrac < 0 ? 0 : minFrac;
            int n2 = maxFrac < 0 ? -1 : (maxFrac = maxFrac < minFrac ? minFrac : maxFrac);
            int n3 = minInt <= 0 ? 1 : (minInt = minInt > 999 ? 1 : minInt);
            maxInt = maxInt < 0 ? -1 : (maxInt < minInt ? minInt : (maxInt > 999 ? -1 : maxInt));
        }
        Precision rounding = null;
        if (explicitCurrencyUsage) {
            rounding = Precision.constructCurrency(currencyUsage).withCurrency(currency);
        } else if (roundingIncrement != null) {
            if (PatternStringUtils.ignoreRoundingIncrement(roundingIncrement, maxFrac)) {
                rounding = Precision.constructFraction(minFrac, maxFrac);
            } else {
                if (minFrac > roundingIncrement.scale()) {
                    roundingIncrement = roundingIncrement.setScale(minFrac);
                }
                rounding = Precision.constructIncrement(roundingIncrement);
            }
        } else if (explicitMinMaxSig) {
            int n = minSig < 1 ? 1 : (minSig = minSig > 999 ? 999 : minSig);
            maxSig = maxSig < 0 ? 999 : (maxSig < minSig ? minSig : (maxSig > 999 ? 999 : maxSig));
            rounding = Precision.constructSignificant(minSig, maxSig);
        } else if (explicitMinMaxFrac) {
            rounding = Precision.constructFraction(minFrac, maxFrac);
        } else if (useCurrency) {
            rounding = Precision.constructCurrency(currencyUsage);
        }
        if (rounding != null) {
            macros.precision = rounding = rounding.withMode(mathContext);
        }
        macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
        macros.grouping = Grouper.forProperties(properties);
        if (properties.getFormatWidth() > 0) {
            macros.padder = Padder.forProperties(properties);
        }
        macros.decimal = properties.getDecimalSeparatorAlwaysShown() ? NumberFormatter.DecimalSeparatorDisplay.ALWAYS : NumberFormatter.DecimalSeparatorDisplay.AUTO;
        NumberFormatter.SignDisplay signDisplay = macros.sign = properties.getSignAlwaysShown() ? NumberFormatter.SignDisplay.ALWAYS : NumberFormatter.SignDisplay.AUTO;
        if (properties.getMinimumExponentDigits() != -1) {
            if (maxInt > 8) {
                maxInt = minInt;
                macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
            } else if (maxInt > minInt && minInt > 1) {
                minInt = 1;
                macros.integerWidth = IntegerWidth.zeroFillTo(minInt).truncateAt(maxInt);
            }
            int engineering = maxInt < 0 ? -1 : maxInt;
            macros.notation = new ScientificNotation(engineering, engineering == minInt, properties.getMinimumExponentDigits(), properties.getExponentSignAlwaysShown() ? NumberFormatter.SignDisplay.ALWAYS : NumberFormatter.SignDisplay.AUTO);
            if (macros.precision instanceof FractionPrecision) {
                int maxInt_ = properties.getMaximumIntegerDigits();
                int minInt_ = properties.getMinimumIntegerDigits();
                int minFrac_ = properties.getMinimumFractionDigits();
                int maxFrac_ = properties.getMaximumFractionDigits();
                if (minInt_ == 0 && maxFrac_ == 0) {
                    macros.precision = Precision.constructInfinite().withMode(mathContext);
                } else if (minInt_ == 0 && minFrac_ == 0) {
                    macros.precision = Precision.constructSignificant(1, maxFrac_ + 1).withMode(mathContext);
                } else {
                    int maxSig_ = minInt_ + maxFrac_;
                    if (maxInt_ > minInt_ && minInt_ > 1) {
                        minInt_ = 1;
                    }
                    int minSig_ = minInt_ + minFrac_;
                    macros.precision = Precision.constructSignificant(minSig_, maxSig_).withMode(mathContext);
                }
            }
        }
        if (properties.getCompactStyle() != null) {
            macros.notation = properties.getCompactCustomData() != null ? new CompactNotation(properties.getCompactCustomData()) : (properties.getCompactStyle() == CompactDecimalFormat.CompactStyle.LONG ? Notation.compactLong() : Notation.compactShort());
            macros.affixProvider = null;
        }
        macros.scale = RoundingUtils.scaleFromProperties(properties);
        if (exportedProperties != null) {
            exportedProperties.setCurrency(currency);
            exportedProperties.setMathContext(mathContext);
            exportedProperties.setRoundingMode(mathContext.getRoundingMode());
            exportedProperties.setMinimumIntegerDigits(minInt);
            exportedProperties.setMaximumIntegerDigits(maxInt == -1 ? Integer.MAX_VALUE : maxInt);
            Precision rounding_ = rounding instanceof CurrencyPrecision ? ((CurrencyPrecision)rounding).withCurrency(currency) : rounding;
            int minFrac_ = minFrac;
            int maxFrac_ = maxFrac;
            int minSig_ = minSig;
            int maxSig_ = maxSig;
            BigDecimal increment_ = null;
            if (rounding_ instanceof Precision.FractionRounderImpl) {
                minFrac_ = ((Precision.FractionRounderImpl)rounding_).minFrac;
                maxFrac_ = ((Precision.FractionRounderImpl)rounding_).maxFrac;
            } else if (rounding_ instanceof Precision.IncrementRounderImpl) {
                increment_ = ((Precision.IncrementRounderImpl)rounding_).increment;
                minFrac_ = increment_.scale();
                maxFrac_ = increment_.scale();
            } else if (rounding_ instanceof Precision.SignificantRounderImpl) {
                minSig_ = ((Precision.SignificantRounderImpl)rounding_).minSig;
                maxSig_ = ((Precision.SignificantRounderImpl)rounding_).maxSig;
            }
            exportedProperties.setMinimumFractionDigits(minFrac_);
            exportedProperties.setMaximumFractionDigits(maxFrac_);
            exportedProperties.setMinimumSignificantDigits(minSig_);
            exportedProperties.setMaximumSignificantDigits(maxSig_);
            exportedProperties.setRoundingIncrement(increment_);
        }
        return macros;
    }
}

