/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs;

import java.nio.file.LinkOption;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.TruffleFile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.TruffleLanguage;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.GlobalBuiltins;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs.CommonJSRequireBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;

public abstract class CommonJSDirnameGetterBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    CommonJSDirnameGetterBuiltin(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected Object getDirName() {
        return this.getCurrentFolderName();
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleString getCurrentFolderName() {
        String filePath = CommonJSResolution.getCurrentFileNameFromStack();
        TruffleLanguage.Env env = this.getRealm().getEnv();
        if (filePath != null) {
            TruffleFile truffleFile = env.getPublicTruffleFile(filePath);
            assert (truffleFile.isRegularFile(new LinkOption[0]) && truffleFile.getParent().isDirectory(new LinkOption[0]));
            return Strings.fromJavaString(truffleFile.getParent().normalize().toString());
        }
        return Strings.fromJavaString(CommonJSRequireBuiltin.getModuleResolveCurrentWorkingDirectory(this.getContext(), env).getAbsoluteFile().toString());
    }
}

