/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.TruffleFile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.GlobalBuiltins;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs.CommonJSRequireBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSErrorType;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSException;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;

public abstract class CommonJSResolveBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    CommonJSResolveBuiltin(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected TruffleString resolve(TruffleString moduleIdentifier) {
        JSRealm realm = this.getRealm();
        TruffleFile cwd = CommonJSRequireBuiltin.getModuleResolveCurrentWorkingDirectory(this.getContext(), realm.getEnv());
        TruffleFile maybeModule = CommonJSResolution.resolve(realm, moduleIdentifier.toJavaStringUncached(), cwd);
        if (maybeModule == null) {
            throw CommonJSResolveBuiltin.fail(moduleIdentifier);
        }
        return Strings.fromJavaString(maybeModule.getAbsoluteFile().normalize().toString());
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException fail(TruffleString moduleIdentifier) {
        return JSException.create(JSErrorType.TypeError, "Cannot find module: '" + moduleIdentifier + "'");
    }
}

