/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.DeclareGlobalNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.DeclareGlobalVariableNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertySetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSGlobal;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSAttributes;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class DeclareGlobalVariableNode
extends DeclareGlobalNode {
    private final boolean configurable;
    @Node.Child
    private HasPropertyCacheNode hasOwnPropertyNode;
    @Node.Child
    private IsExtensibleNode isExtensibleNode = IsExtensibleNode.create();

    protected DeclareGlobalVariableNode(TruffleString varName, boolean configurable) {
        super(varName);
        this.configurable = configurable;
    }

    public static DeclareGlobalVariableNode create(TruffleString varName, boolean configurable) {
        return DeclareGlobalVariableNodeGen.create(varName, configurable);
    }

    @Override
    public void verify(JSContext context, JSRealm realm) {
        super.verify(context, realm);
        JSDynamicObject globalObject = realm.getGlobalObject();
        if (this.hasOwnPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.hasOwnPropertyNode = this.insert(HasPropertyCacheNode.create(this.varName, context, true));
        }
        if (!this.hasOwnPropertyNode.hasProperty(globalObject) && !this.isExtensibleNode.executeBoolean(globalObject)) {
            this.errorProfile.enter();
            throw Errors.createTypeErrorGlobalObjectNotExtensible(this);
        }
    }

    @Override
    public final void executeVoid(VirtualFrame frame, JSContext context, JSRealm realm) {
        JSDynamicObject globalObject = realm.getGlobalObject();
        if (!this.hasOwnPropertyNode.hasProperty(globalObject)) {
            assert (JSObject.isExtensible(globalObject));
            this.executeVoid(globalObject, context);
        }
    }

    protected abstract void executeVoid(JSDynamicObject var1, JSContext var2);

    @Specialization(guards={"context.getPropertyCacheLimit() > 0", "isJSGlobalObject(globalObject)"})
    protected void doCached(JSDynamicObject globalObject, JSContext context, @Cached(value="makeDefineOwnPropertyCache(context)") PropertySetNode cache) {
        cache.setValue(globalObject, Undefined.instance);
    }

    @Specialization(replaces={"doCached"})
    protected void doUncached(JSDynamicObject globalObject, JSContext context) {
        if (JSGlobal.isJSGlobalObject(globalObject)) {
            JSObjectUtil.putDeclaredDataProperty(context, globalObject, this.varName, Undefined.instance, this.getAttributeFlags());
        } else {
            PropertyDescriptor desc = this.configurable ? PropertyDescriptor.undefinedDataDesc : PropertyDescriptor.undefinedDataDescNotConfigurable;
            JSObject.defineOwnProperty(globalObject, this.varName, desc, true);
        }
    }

    private int getAttributeFlags() {
        return this.configurable ? JSAttributes.configurableEnumerableWritable() : JSAttributes.notConfigurableEnumerableWritable();
    }

    protected final PropertySetNode makeDefineOwnPropertyCache(JSContext context) {
        return PropertySetNode.createImpl(this.varName, false, context, true, true, this.getAttributeFlags(), true);
    }

    @Override
    protected DeclareGlobalNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return DeclareGlobalVariableNode.create(this.varName, this.configurable);
    }
}

