/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import java.util.List;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.ImportStatic;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnknownIdentifierException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.helper.ListGetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.helper.ListSizeNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.HasOnlyShapePropertiesNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSConfig;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.ScriptArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSClass;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSProxy;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSShape;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.JSClassProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.SimpleArrayList;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;

@ImportStatic(value={JSConfig.class})
public abstract class EnumerableOwnPropertyNamesNode
extends JavaScriptBaseNode {
    private final boolean keys;
    private final boolean values;
    private final JSContext context;
    @Node.Child
    private JSGetOwnPropertyNode getOwnPropertyNode;
    private final ConditionProfile hasFastShapesProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile growProfile = BranchProfile.create();

    protected EnumerableOwnPropertyNamesNode(JSContext context, boolean keys, boolean values) {
        this.context = context;
        this.keys = keys;
        this.values = values;
    }

    public static EnumerableOwnPropertyNamesNode createKeys(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, true, false);
    }

    public static EnumerableOwnPropertyNamesNode createValues(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, false, true);
    }

    public static EnumerableOwnPropertyNamesNode createKeysValues(JSContext context) {
        return EnumerableOwnPropertyNamesNodeGen.create(context, true, true);
    }

    public abstract UnmodifiableArrayList<? extends Object> execute(Object var1);

    @Specialization
    protected UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNames(JSDynamicObject thisObj, @Cached JSClassProfile jsclassProfile, @Cached ListSizeNode listSize, @Cached ListGetNode listGet, @Cached HasOnlyShapePropertiesNode hasOnlyShapeProperties) {
        JSClass jsclass = jsclassProfile.getJSClass(thisObj);
        if (this.hasFastShapesProfile.profile(this.keys && !this.values && hasOnlyShapeProperties.execute(thisObj, jsclass))) {
            return JSShape.getEnumerablePropertyNames(thisObj.getShape());
        }
        boolean isProxy = JSProxy.isJSProxy(thisObj);
        List<Object> ownKeys = jsclass.ownPropertyKeys(thisObj);
        int ownKeysSize = listSize.execute(ownKeys);
        SimpleArrayList<Object> properties = new SimpleArrayList<Object>();
        for (int i = 0; i < ownKeysSize; ++i) {
            Object element;
            PropertyDescriptor desc;
            Object key = listGet.execute(ownKeys, i);
            if (!Strings.isTString(key) || (desc = this.getOwnProperty(thisObj, key)) == null || !desc.getEnumerable()) continue;
            if (this.keys && !this.values) {
                element = key;
            } else {
                Object value;
                Object object = value = desc.isAccessorDescriptor() || isProxy ? jsclass.get(thisObj, key) : desc.getValue();
                if (!this.keys && this.values) {
                    element = value;
                } else {
                    assert (this.keys && this.values);
                    element = this.createKeyValuePair(key, value);
                }
            }
            properties.add(element, this.growProfile);
        }
        return new UnmodifiableArrayList<Object>(properties.toArray());
    }

    private Object createKeyValuePair(Object key, Object value) {
        return JSArray.createConstant(this.context, this.getRealm(), new Object[]{key, value});
    }

    protected PropertyDescriptor getOwnProperty(JSDynamicObject thisObj, Object key) {
        if (this.getOwnPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getOwnPropertyNode = this.insert(JSGetOwnPropertyNode.create(this.values, true, false, false, false));
        }
        return this.getOwnPropertyNode.execute(thisObj, key);
    }

    @Specialization(guards={"isForeignObject(obj)"}, limit="InteropLibraryLimit")
    protected UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNamesForeign(Object obj, @CachedLibrary(value="obj") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary members, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary asString, @Cached ImportValueNode importValue, @Cached BranchProfile errorBranch) {
        try {
            long arraySize = 0L;
            if (interop.hasArrayElements(obj)) {
                arraySize = interop.getArraySize(obj);
            }
            Object keysObj = null;
            long memberCount = 0L;
            if (interop.hasMembers(obj)) {
                keysObj = interop.getMembers(obj);
                memberCount = members.getArraySize(keysObj);
            }
            long size = arraySize + memberCount;
            if (arraySize < 0L || memberCount < 0L || size < 0L || size >= Integer.MAX_VALUE) {
                errorBranch.enter();
                throw Errors.createRangeErrorInvalidArrayLength();
            }
            if (size > 0L) {
                Object element;
                TruffleString key;
                SimpleArrayList<Object> list = new SimpleArrayList<Object>((int)size);
                for (long i = 0L; i < arraySize; ++i) {
                    key = Strings.fromLong(i);
                    if (this.values) {
                        Object value = importValue.executeWithTarget(interop.readArrayElement(obj, i));
                        element = this.keys ? this.createKeyValuePair(key, value) : value;
                    } else {
                        element = key;
                    }
                    list.addUnchecked(element);
                }
                int i = 0;
                while ((long)i < memberCount) {
                    Object objectKey = members.readArrayElement(keysObj, i);
                    assert (InteropLibrary.getUncached().isString(objectKey));
                    key = Strings.interopAsTruffleString(asString, objectKey);
                    if (this.values) {
                        String javaStringKey = Strings.toJavaString(key);
                        Object value = importValue.executeWithTarget(interop.readMember(obj, javaStringKey));
                        element = this.keys ? this.createKeyValuePair(key, value) : value;
                    } else {
                        element = key;
                    }
                    list.addUnchecked(element);
                    ++i;
                }
                return new UnmodifiableArrayList<Object>(list.toArray());
            }
        }
        catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException interopException) {
            // empty catch block
        }
        return new UnmodifiableArrayList<Object>(ScriptArray.EMPTY_OBJECT_ARRAY);
    }
}

