/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Fallback;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsJSClassNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsRegExpNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Symbol;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSRegExp;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class IsRegExpNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getSymbolMatchNode;

    IsRegExpNode(JSContext context) {
        this.getSymbolMatchNode = this.insert(PropertyGetNode.create(Symbol.SYMBOL_MATCH, false, context));
    }

    public abstract boolean executeBoolean(Object var1);

    @Specialization
    boolean doIsObject(JSDynamicObject obj, @Cached(value="create()") IsJSObjectNode isObjectNode, @Cached(value="create()") JSToBooleanNode toBooleanNode, @Cached(value="createIsJSRegExpNode()") IsJSClassNode isJSRegExpNode, @Cached(value="createBinaryProfile()") ConditionProfile hasMatchSymbol) {
        if (!isObjectNode.executeBoolean(obj)) {
            return false;
        }
        Object isRegExp = this.getSymbolMatchNode.getValue(obj);
        if (hasMatchSymbol.profile(isRegExp != Undefined.instance)) {
            return toBooleanNode.executeBoolean(isRegExp);
        }
        return isJSRegExpNode.executeBoolean(obj);
    }

    @Fallback
    boolean doNonObject(Object obj) {
        return false;
    }

    static IsJSClassNode createIsJSRegExpNode() {
        return IsJSClassNode.create(JSRegExp.INSTANCE);
    }

    public static IsRegExpNode create(JSContext context) {
        return IsRegExpNodeGen.create(context);
    }
}

