/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.StandardTags;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JSNodeUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.arguments.AccessArgumentsArrayDirectlyNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.instrumentation.JSTags;

public class CallApplyArgumentsNode
extends JavaScriptNode {
    @Node.Child
    private JSFunctionCallNode.InvokeNode callNode;

    protected CallApplyArgumentsNode(JSFunctionCallNode callNode) {
        this.callNode = (JSFunctionCallNode.InvokeNode)callNode;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        Object target = this.callNode.executeTarget(frame);
        Object function = this.callNode.executeFunctionWithTarget(frame, target);
        if (function != this.getRealm().getApplyFunctionObject()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.replaceWithOrdinaryCall();
        }
        return this.callNode.executeCall(this.callNode.createArguments(frame, target, function));
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(StandardTags.ExpressionTag.class) || materializedTags.contains(JSTags.FunctionCallTag.class)) {
            this.replaceWithOrdinaryCall();
        }
        return this;
    }

    private void replaceWithOrdinaryCall() {
        this.atomic(() -> {
            for (JavaScriptNode n : this.callNode.getArgumentNodes()) {
                JavaScriptNode node = JSNodeUtil.getWrappedNode(n);
                if (!(node instanceof AccessArgumentsArrayDirectlyNode)) continue;
                ((AccessArgumentsArrayDirectlyNode)node).replaceWithDefaultArguments();
            }
            this.replace(this.callNode, "not the built-in apply function");
        });
    }

    public static JavaScriptNode create(JSFunctionCallNode callNode) {
        return new CallApplyArgumentsNode(callNode);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return CallApplyArgumentsNode.create(CallApplyArgumentsNode.cloneUninitialized(this.callNode, materializedTags));
    }
}

