/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.GenerateUncached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.ImportStatic;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSConfig;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@GenerateUncached
@ImportStatic(value={JSConfig.class})
public abstract class ForeignObjectPrototypeNode
extends JavaScriptBaseNode {
    public abstract JSDynamicObject execute(Object var1);

    @Specialization(limit="InteropLibraryLimit")
    public JSDynamicObject doTruffleObject(Object truffleObject, @CachedLibrary(value="truffleObject") InteropLibrary interop) {
        JSRealm realm = this.getRealm();
        if (interop.hasArrayElements(truffleObject)) {
            return realm.getForeignArrayPrototype();
        }
        if (interop.isInstant(truffleObject)) {
            return realm.getForeignDatePrototype();
        }
        if (interop.hasHashEntries(truffleObject)) {
            return realm.getForeignMapPrototype();
        }
        if (interop.hasIterator(truffleObject)) {
            return realm.getForeignIterablePrototype();
        }
        if (interop.isString(truffleObject)) {
            return realm.getForeignStringPrototype();
        }
        if (interop.isNumber(truffleObject)) {
            return realm.getForeignNumberPrototype();
        }
        if (interop.isBoolean(truffleObject)) {
            return realm.getForeignBooleanPrototype();
        }
        if (interop.isExecutable(truffleObject) || interop.isInstantiable(truffleObject)) {
            return realm.getForeignFunctionPrototype();
        }
        return realm.getForeignObjectPrototype();
    }

    public static ForeignObjectPrototypeNode create() {
        return ForeignObjectPrototypeNodeGen.create();
    }

    public static ForeignObjectPrototypeNode getUncached() {
        return ForeignObjectPrototypeNodeGen.getUncached();
    }
}

