/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.intl;

import java.util.ArrayList;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.ImportStatic;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.TypeOfNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Boundaries;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSConfig;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.intl.JSLocaleObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.IntlUtil;

@ImportStatic(value={JSConfig.class})
public abstract class JSToCanonicalizedLocaleListNode
extends JavaScriptBaseNode {
    final JSContext context;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected JSToCanonicalizedLocaleListNode(JSContext context) {
        this.context = context;
    }

    public static JSToCanonicalizedLocaleListNode create(JSContext context) {
        return JSToCanonicalizedLocaleListNodeGen.create(context);
    }

    public abstract String[] executeLanguageTags(Object var1);

    @Specialization
    protected String[] doTString(TruffleString s) {
        return JSToCanonicalizedLocaleListNode.doJavaString(Strings.toJavaString(s));
    }

    @Specialization(guards={"isUndefined(object)"})
    protected String[] doUndefined(Object object) {
        return new String[0];
    }

    @Specialization
    protected String[] doLocale(JSLocaleObject object) {
        return JSToCanonicalizedLocaleListNode.doJavaString(JSLocale.getInternalState(object).getLocale());
    }

    @Specialization(guards={"!isForeignObject(object)", "!isString(object)", "!isUndefined(object)", "!isJSLocale(object)"})
    protected String[] doOtherType(Object object, @Cached(value="createToObject(context)") JSToObjectNode toObjectNode, @Cached(value="create(context)") JSGetLengthNode getLengthNode, @Cached JSHasPropertyNode hasPropertyNode, @Cached TypeOfNode typeOfNode, @Cached JSToStringNode toStringNode, @Cached @Cached.Shared(value="equalsNode") TruffleString.EqualNode equalsNode, @Cached @Cached.Shared(value="toJavaStringNode") TruffleString.ToJavaStringNode toJavaStringNode) {
        ArrayList result = new ArrayList();
        JSDynamicObject localeObj = (JSDynamicObject)toObjectNode.execute(object);
        long len = getLengthNode.executeLong(localeObj);
        for (long k = 0L; k < len; ++k) {
            if (!hasPropertyNode.executeBoolean((Object)localeObj, k)) continue;
            Object kValue = JSObject.get(localeObj, k);
            TruffleString typeOfKValue = typeOfNode.executeString(kValue);
            if (JSRuntime.isNullOrUndefined(kValue) || !Strings.equals(equalsNode, Strings.STRING, typeOfKValue) && !Strings.equals(equalsNode, Strings.OBJECT, typeOfKValue)) {
                this.errorBranch.enter();
                throw Errors.createTypeError(Boundaries.stringFormat("String or Object expected in locales list, got %s", typeOfKValue));
            }
            String lt = JSLocale.isJSLocale(kValue) ? JSLocale.getInternalState((JSDynamicObject)kValue).getLocale() : Strings.toJavaString(toJavaStringNode, toStringNode.executeString(kValue));
            String canonicalizedLt = IntlUtil.validateAndCanonicalizeLanguageTag(lt);
            if (Boundaries.listContains(result, canonicalizedLt)) continue;
            Boundaries.listAdd(result, canonicalizedLt);
        }
        return result.toArray(new String[0]);
    }

    @Specialization(guards={"isForeignObject(object)"})
    protected String[] doForeignType(Object object, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached TypeOfNode typeOfNode, @Cached JSToStringNode toStringNode, @Cached @Cached.Shared(value="equalsNode") TruffleString.EqualNode equalsNode, @Cached @Cached.Shared(value="toJavaStringNode") TruffleString.ToJavaStringNode toJavaStringNode) {
        long len;
        ArrayList result = new ArrayList();
        try {
            len = interop.getArraySize(object);
        }
        catch (UnsupportedMessageException e) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorInteropException(object, e, "getArraySize", this);
        }
        for (long k = 0L; k < len; ++k) {
            Object kValue;
            if (!interop.isArrayElementReadable(object, k)) continue;
            try {
                kValue = interop.readArrayElement(object, k);
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorInteropException(object, e, "readArrayElement", k, this);
            }
            TruffleString typeOfKValue = typeOfNode.executeString(kValue);
            if (!Strings.equals(equalsNode, Strings.STRING, typeOfKValue) && !Strings.equals(equalsNode, Strings.OBJECT, typeOfKValue)) {
                this.errorBranch.enter();
                throw Errors.createTypeError(Boundaries.stringFormat("String or Object expected in locales list, got %s", typeOfKValue));
            }
            String lt = Strings.toJavaString(toJavaStringNode, toStringNode.executeString(kValue));
            String canonicalizedLt = IntlUtil.validateAndCanonicalizeLanguageTag(lt);
            if (Boundaries.listContains(result, canonicalizedLt)) continue;
            Boundaries.listAdd(result, canonicalizedLt);
        }
        return result.toArray(new String[0]);
    }

    private static String[] doJavaString(String s) {
        return new String[]{IntlUtil.validateAndCanonicalizeLanguageTag(s)};
    }
}

