/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.intl;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JSGuards;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.CreateObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.IntlUtil;

public abstract class ToDateTimeOptionsNode
extends JavaScriptBaseNode {
    private static final String ALL = "all";
    private static final String ANY = "any";
    private static final String DATE = "date";
    private static final String TIME = "time";
    @Node.Child
    JSToObjectNode toObjectNode;
    final JSContext context;

    public JSContext getContext() {
        return this.context;
    }

    public ToDateTimeOptionsNode(JSContext context) {
        this.context = context;
    }

    public abstract JSDynamicObject execute(Object var1, String var2, String var3);

    @Specialization(guards={"isUndefined(opts)"})
    public JSDynamicObject fromUndefined(Object opts, String required, String defaults) {
        return ToDateTimeOptionsNode.setDefaultsIfNeeded(JSOrdinary.createWithNullPrototype(this.getContext()), required, defaults);
    }

    @Specialization(guards={"!isUndefined(opts)"})
    public JSDynamicObject fromOtherThenUndefined(Object opts, String required, String defaults, @Cached(value="createOrdinaryWithPrototype(context)") CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode) {
        JSDynamicObject options = createObjectNode.execute(this.toDynamicObject(opts));
        return ToDateTimeOptionsNode.setDefaultsIfNeeded(options, required, defaults);
    }

    private static JSDynamicObject setDefaultsIfNeeded(JSDynamicObject options, String required, String defaults) {
        boolean needDefaults = true;
        if (required != null) {
            if (DATE.equals(required) || ANY.equals(required)) {
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.WEEKDAY));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.YEAR));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.MONTH));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.DAY));
            }
            if (TIME.equals(required) || ANY.equals(required)) {
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, IntlUtil.KEY_DAY_PERIOD));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.HOUR));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.MINUTE));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.SECOND));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, IntlUtil.KEY_FRACTIONAL_SECOND_DIGITS));
            }
        }
        Object dateStyle = JSObject.get(options, Strings.DATE_STYLE);
        Object timeStyle = JSObject.get(options, Strings.TIME_STYLE);
        if (dateStyle != Undefined.instance || timeStyle != Undefined.instance) {
            needDefaults = false;
        }
        if (DATE.equals(required) && timeStyle != Undefined.instance) {
            throw Errors.createTypeError("timeStyle option is not allowed here");
        }
        if (TIME.equals(required) && dateStyle != Undefined.instance) {
            throw Errors.createTypeError("dateStyle option is not allowed here");
        }
        if (defaults != null) {
            if (needDefaults && (DATE.equals(defaults) || ALL.equals(defaults))) {
                JSRuntime.createDataPropertyOrThrow(options, Strings.YEAR, Strings.NUMERIC);
                JSRuntime.createDataPropertyOrThrow(options, Strings.MONTH, Strings.NUMERIC);
                JSRuntime.createDataPropertyOrThrow(options, Strings.DAY, Strings.NUMERIC);
            }
            if (needDefaults && (TIME.equals(defaults) || ALL.equals(defaults))) {
                JSRuntime.createDataPropertyOrThrow(options, Strings.HOUR, Strings.NUMERIC);
                JSRuntime.createDataPropertyOrThrow(options, Strings.MINUTE, Strings.NUMERIC);
                JSRuntime.createDataPropertyOrThrow(options, Strings.SECOND, Strings.NUMERIC);
            }
        }
        return options;
    }

    private JSDynamicObject toDynamicObject(Object o) {
        if (this.toObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toObjectNode = this.insert(JSToObjectNode.createToObject(this.getContext()));
        }
        return (JSDynamicObject)this.toObjectNode.execute(o);
    }
}

