/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSDate;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSDateObject
extends JSNonProxyObject {
    private double value;

    protected JSDateObject(Shape shape, double value) {
        super(shape);
        this.value = value;
    }

    public double getTimeMillis() {
        return this.value;
    }

    public void setTimeMillis(double value) {
        this.value = value;
    }

    public static JSDateObject create(Shape shape, double value) {
        return new JSDateObject(shape, value);
    }

    @Override
    public TruffleString getClassName() {
        return JSDate.CLASS_NAME;
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return this.getClassName();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isDate"), @ExportMessage(name="isTime"), @ExportMessage(name="isTimeZone")})
    protected boolean isDate() {
        return JSDate.isValidDate(this);
    }

    @ExportMessage
    public LocalDate asDate(@CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSDate.asLocalDate(this, JSRealm.get(self));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public LocalTime asTime(@CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSDate.asLocalTime(this, JSRealm.get(self));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public ZoneId asTimeZone(@CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSRealm.get(self).getLocalTimeZoneId();
        }
        throw UnsupportedMessageException.create();
    }
}

