/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.regex;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.exception.AbstractTruffleException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.ExceptionType;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.RegexSource;

@ExportLibrary(value=InteropLibrary.class)
public final class UnsupportedRegexException
extends AbstractTruffleException {
    private String reason;
    private RegexSource regexSrc;

    public UnsupportedRegexException(String reason) {
        this.reason = reason;
    }

    public UnsupportedRegexException(String reason, RegexSource regexSrc) {
        this(reason);
        this.regexSrc = regexSrc;
    }

    public RegexSource getRegex() {
        return this.regexSrc;
    }

    public void setRegex(RegexSource regexSrc) {
        this.regexSrc = regexSrc;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Unsupported regular expression");
        if (this.regexSrc != null) {
            sb.append(" /");
            sb.append(this.regexSrc.getPattern());
            sb.append("/");
            sb.append(this.regexSrc.getFlags());
        }
        if (this.reason != null) {
            sb.append(": ");
            sb.append(this.reason);
        }
        return sb.toString();
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return ExceptionType.PARSE_ERROR;
    }
}

