/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.DebugValue;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.BreakpointsHandler;

public final class ConsoleUtilitiesAPI {
    private final Method method;
    private final String expression;

    private ConsoleUtilitiesAPI(Method method, String expression) {
        this.method = method;
        this.expression = expression;
    }

    public static ConsoleUtilitiesAPI parse(String expression) {
        for (Method method : Method.values()) {
            int i;
            if (!expression.startsWith(method.getMethod())) continue;
            for (i = method.getMethod().length(); i < expression.length() && Character.isWhitespace(expression.charAt(i)); ++i) {
            }
            if (i >= expression.length() || expression.charAt(i) != '(' || !expression.endsWith(")")) continue;
            return new ConsoleUtilitiesAPI(method, expression.substring(i + 1, expression.length() - 1).trim());
        }
        return null;
    }

    public String getExpression() {
        return this.expression;
    }

    public DebugValue process(DebugValue value, BreakpointsHandler breakpointsHandler) {
        switch (this.method) {
            case DEBUG: {
                breakpointsHandler.createFunctionBreakpoint(value, null);
                return null;
            }
            case UNDEBUG: {
                breakpointsHandler.removeFunctionBreakpoint(value);
                return null;
            }
        }
        throw new IllegalStateException("Unknown API method " + this.method.name());
    }

    static enum Method {
        DEBUG("debug"),
        UNDEBUG("undebug");

        private final String method;

        private Method(String method) {
            this.method = method;
        }

        String getMethod() {
            return this.method;
        }
    }
}

