/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.DebugException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.DebugStackFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.SuspendAnchor;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.source.SourceSection;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.Location;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.Scope;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.Script;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONObject;

public final class CallFrame {
    private final DebugStackFrame frame;
    private final int depth;
    private final Location location;
    private final Location functionLocation;
    private final String url;
    private final RemoteObject thisObject;
    private final RemoteObject returnObject;
    private final Scope[] scopes;

    public CallFrame(DebugStackFrame frame, int depth, Script script, SourceSection sourceSection, SuspendAnchor anchor, SourceSection functionSourceSection, RemoteObject thisObject, RemoteObject returnObject, Scope ... scopes) {
        this.frame = frame;
        this.depth = depth;
        this.location = anchor == SuspendAnchor.BEFORE ? new Location(script.getId(), sourceSection.getStartLine(), sourceSection.getStartColumn()) : new Location(script.getId(), sourceSection.getEndLine(), sourceSection.getEndColumn() + 1);
        this.functionLocation = functionSourceSection != null ? new Location(script.getId(), functionSourceSection.getStartLine(), functionSourceSection.getStartColumn()) : null;
        this.url = script.getUrl();
        this.thisObject = thisObject;
        this.returnObject = returnObject;
        this.scopes = scopes;
    }

    public DebugStackFrame getFrame() {
        return this.frame;
    }

    public String getFunctionName() {
        return this.frame.getName();
    }

    public Location getLocation() {
        return this.location;
    }

    public Scope[] getScopeChain() {
        return this.scopes;
    }

    public RemoteObject getThis() {
        return this.thisObject;
    }

    public RemoteObject getReturnValue() {
        return this.returnObject;
    }

    private JSONObject createJSON() {
        JSONObject json = new JSONObject();
        json.put("callFrameId", Integer.toString(this.depth));
        try {
            String functionName = this.frame.getName();
            if (functionName == null) {
                functionName = "";
            }
            json.put("functionName", functionName);
        }
        catch (DebugException ex) {
            json.put("functionName", ex.getLocalizedMessage());
        }
        json.put("location", this.location.toJSON());
        json.putOpt("functionLocation", this.functionLocation != null ? this.functionLocation.toJSON() : null);
        json.put("url", this.url);
        json.put("scopeChain", Scope.createScopesJSON(this.scopes));
        if (this.thisObject != null) {
            json.put("this", this.thisObject.toJSON());
        } else {
            json.put("this", JSONObject.NULL);
        }
        if (this.returnObject != null) {
            json.put("returnValue", this.returnObject.toJSON());
        }
        return json;
    }

    public JSONObject toJSON() {
        return this.createJSON();
    }
}

