/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.compute.data;

import java.util.List;
import kasuga.lib.vendor_modules.interpreter.compute.exceptions.FormulaOperationError;
import kasuga.lib.vendor_modules.interpreter.compute.exceptions.FormulaSynatxError;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;

public class Operational
implements Formula {
    String operation = "+";
    boolean shouldRemove = false;

    public Operational(String string) {
        this.fromString(string);
    }

    @Override
    public String getString() {
        return this.operation;
    }

    @Override
    public String getIdentifier() {
        return "operational";
    }

    @Override
    public float getResult() {
        return 0.0f;
    }

    @Override
    public List<Formula> getElements() {
        return List.of(this);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean shouldRemove() {
        return this.shouldRemove;
    }

    @Override
    public void fromString(String string) {
        String s = string.trim();
        if (Operational.isOperational(s)) {
            this.operation = string;
        }
    }

    public static int getOperationIndex(String string, int index) {
        String x = string.replaceAll("(\\+|-|\\*|/|\\^|%)", "OPT");
        return x.indexOf("OPT", index);
    }

    public static int getOperationIndex(String string) {
        return Operational.getOperationIndex(string, 0);
    }

    public float operate(Formula former, Formula rear) {
        if (former instanceof Operational) {
            throw new FormulaOperationError(former, this, rear);
        }
        switch (this.operation) {
            case "+": {
                return former.getResult() + rear.getResult();
            }
            case "-": {
                return former.getResult() - rear.getResult();
            }
            case "*": {
                return former.getResult() * rear.getResult();
            }
            case "/": {
                return former.getResult() / rear.getResult();
            }
            case "%": {
                return former.getResult() % rear.getResult();
            }
            case "^": {
                return (float)Math.pow(former.getResult(), rear.getResult());
            }
        }
        return 0.0f;
    }

    public static boolean isOperational(String string) {
        String s = string.replaceAll(" ", "");
        return s.equals("+") || s.equals("-") || s.equals("*") || s.equals("/") || s.equals("%") || s.equals("^");
    }

    public void mergeOperation(Formula f, Formula parent, int index) {
        if (f instanceof Operational) {
            Operational fromer = (Operational)f;
            block5 : switch (this.operation) {
                case "+": {
                    switch (fromer.operation) {
                        case "+": {
                            fromer.shouldRemove = true;
                            break block5;
                        }
                        case "-": {
                            fromer.shouldRemove = true;
                            this.operation = "-";
                            break block5;
                        }
                    }
                    this.shouldRemove = true;
                    break;
                }
                case "-": {
                    switch (fromer.operation) {
                        case "+": {
                            fromer.shouldRemove = true;
                            break;
                        }
                        case "-": {
                            fromer.shouldRemove = true;
                            this.operation = "+";
                        }
                    }
                    break;
                }
                case "*": {
                    if (fromer.operation.equals("*")) {
                        fromer.shouldRemove = true;
                        this.operation = "^";
                        break;
                    }
                    throw new FormulaSynatxError(parent, index);
                }
                default: {
                    throw new FormulaSynatxError(parent, index);
                }
            }
        }
    }

    @Override
    public Operational clone() {
        return new Operational(String.copyValueOf(this.operation.toCharArray()));
    }

    @Override
    public void flipOutput(boolean flip) {
    }

    @Override
    public boolean isOutputFlipped() {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Operational)) {
            return false;
        }
        Operational operational = (Operational)obj;
        return operational.operation.equals(this.operation);
    }
}

