/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.compute.data;

import java.util.List;
import java.util.Set;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Assignable;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;

public class Variable
implements Formula,
Assignable {
    private String codec;
    private float value;
    private boolean flip = false;
    private final Namespace namespace;

    public Variable(String codec, Namespace namespace) {
        this.codec = codec;
        this.namespace = namespace;
    }

    public Variable(String codec, Namespace namespace, float value) {
        this(codec, namespace);
        this.value = value;
    }

    public String appendCodec(String append) {
        if (!append.equals("")) {
            this.codec = this.codec + "." + append;
        }
        return this.codec;
    }

    public static boolean isVar(String input) {
        return input.replaceAll("([a-z])([a-z1-9])*(_([a-z1-9]+))*", "").equals("");
    }

    @Override
    public String getString() {
        return (this.flip ? "-" : "") + this.codec;
    }

    @Override
    public String getIdentifier() {
        return "var";
    }

    @Override
    public float getResult() {
        return this.flip ? -this.value : this.value;
    }

    @Override
    public List<Formula> getElements() {
        return List.of(this);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean shouldRemove() {
        return false;
    }

    @Override
    public void fromString(String string) {
        if (Variable.isVar(string)) {
            this.codec = string;
        }
    }

    @Override
    public Formula clone() {
        return new Variable(this.codec, this.namespace, this.value);
    }

    @Override
    public void flipOutput(boolean flip) {
        this.flip = flip;
    }

    @Override
    public boolean isOutputFlipped() {
        return this.flip;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Set<String> variableCodecs() {
        return Set.of(this.codec);
    }

    @Override
    public void assign(String codec, float value) {
        if (codec.equals(this.codec)) {
            this.value = value;
        }
    }

    @Override
    public boolean containsVar(String codec) {
        return codec.equals(this.codec);
    }

    @Override
    public float getValue(String codec) {
        return this.getResult();
    }

    @Override
    public boolean hasVar() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)obj;
        return variable.codec.equals(this.codec);
    }
}

