/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core;

import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.KasugaLibClient;
import kasuga.lib.core.base.CustomBlockRenderer;
import kasuga.lib.core.base.commands.ArgumentTypes.BaseArgument;
import kasuga.lib.core.client.animation.Constants;
import kasuga.lib.core.client.frontend.gui.GuiEngine;
import kasuga.lib.core.client.render.texture.old.SimpleTexture;
import kasuga.lib.core.events.both.BothSetupEvent;
import kasuga.lib.core.events.both.EntityAttributeEvent;
import kasuga.lib.core.events.client.ClientSetupEvent;
import kasuga.lib.core.events.client.ClientTickEvent;
import kasuga.lib.core.events.client.ModelRegistryEvent;
import kasuga.lib.core.events.client.PacketEvent;
import kasuga.lib.core.events.client.RenderTickEvent;
import kasuga.lib.core.events.client.TextureRegistryEvent;
import kasuga.lib.core.events.server.ServerResourceListener;
import kasuga.lib.core.events.server.ServerStartingEvents;
import kasuga.lib.core.javascript.JavascriptApi;
import kasuga.lib.core.util.Envs;
import kasuga.lib.registrations.client.KeyBindingReg;
import kasuga.lib.registrations.create.TrackMaterialReg;
import kasuga.lib.registrations.registry.FontRegistry;
import kasuga.lib.registrations.registry.SimpleRegistry;
import kasuga.lib.registrations.registry.TextureRegistry;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;

public class KasugaLibStacks {
    private final HashMap<String, SimpleRegistry> registries;
    public final IEventBus bus;
    private boolean hasTextureRegistryFired = false;
    private final TextureRegistry TEXTURES;
    private final FontRegistry FONTS;
    private final Random random = new Random();
    private final HashMap<Block, CustomBlockRenderer> BLOCK_RENDERERS;
    public final JavascriptApi JAVASCRIPT = new JavascriptApi();
    public Optional<GuiEngine> GUI = Optional.empty();
    public static final SimpleRegistry REGISTRY = new SimpleRegistry("kasuga_lib", KasugaLib.EVENTS);
    private final HashMap<TrackMaterial, TrackMaterialReg> TRACK_MATERIALS;

    public KasugaLibStacks(IEventBus bus) {
        this.bus = bus;
        this.registries = new HashMap();
        this.TEXTURES = new TextureRegistry("kasuga_lib");
        this.FONTS = new FontRegistry("kasuga_lib");
        this.TRACK_MATERIALS = new HashMap();
        this.BLOCK_RENDERERS = new HashMap();
        MinecraftForge.EVENT_BUS.addListener(ServerStartingEvents::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(ServerStartingEvents::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(PacketEvent::onServerPayloadHandleEvent);
        bus.addListener(BothSetupEvent::onFMLCommonSetup);
        bus.addListener(EntityAttributeEvent::entityAttributeCreation);
        ArgumentTypes.m_121601_((String)"base", BaseArgument.class, (ArgumentSerializer)new BaseArgument.Serializer());
        KeyBindingReg.invoke();
        if (Envs.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(PacketEvent::onClientPayloadHandleEvent);
            MinecraftForge.EVENT_BUS.addListener(Constants::onClientTick);
            MinecraftForge.EVENT_BUS.addListener(Constants::onAnimStart);
            MinecraftForge.EVENT_BUS.addListener(Constants::onAnimStop);
            MinecraftForge.EVENT_BUS.addListener(ClientTickEvent::onClientTick);
            bus.addListener(ModelRegistryEvent::registerAdditionalModels);
            bus.addListener(ModelRegistryEvent::bakingCompleted);
            bus.addListener(TextureRegistryEvent::onModelRegistry);
            bus.addListener(ClientSetupEvent::onClientSetup);
            MinecraftForge.EVENT_BUS.addListener(RenderTickEvent::onRenderTick);
            this.GUI = Optional.of(new GuiEngine());
            KasugaLibClient.invoke();
        }
        MinecraftForge.EVENT_BUS.addListener(ServerResourceListener::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(ServerResourceListener::onServerStopping);
    }

    public void stackIn(SimpleRegistry registry) {
        this.registries.put(registry.namespace, registry);
    }

    public boolean isTextureRegistryFired() {
        return this.hasTextureRegistryFired;
    }

    public void fireTextureRegistry() {
        this.hasTextureRegistryFired = true;
        this.TEXTURES.onRegister();
    }

    public void cacheBlockRendererIn(Block block, CustomBlockRenderer blockRenderer) {
        this.BLOCK_RENDERERS.put(block, blockRenderer);
    }

    public CustomBlockRenderer getBlockRenderer(Block block) {
        return this.BLOCK_RENDERERS.getOrDefault(block, null);
    }

    public void cacheTrackMaterialIn(TrackMaterialReg reg) {
        this.TRACK_MATERIALS.put(reg.getMaterial(), reg);
    }

    public TrackMaterialReg getCachedTrackMaterial(TrackMaterial material) {
        return this.TRACK_MATERIALS.getOrDefault(material, null);
    }

    public HashMap<String, SimpleRegistry> getRegistries() {
        return this.registries;
    }

    public void putUnregisteredPicIn(SimpleTexture pic) {
        this.TEXTURES.stackIn(pic);
    }

    public FontRegistry fontRegistry() {
        return this.FONTS;
    }

    public Random random() {
        return this.random;
    }
}

