/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.addons.resource;

import java.util.ArrayList;
import java.util.List;
import kasuga.lib.core.addons.node.NodePackage;
import kasuga.lib.core.addons.node.NodePackageLoader;
import kasuga.lib.core.addons.node.PackageScanner;
import kasuga.lib.core.addons.resource.ResourceAdapter;
import kasuga.lib.core.addons.resource.ResourceProvider;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ResourceManager;

public class ResourceManagerPackageProvider {
    public List<Pair<NodePackage, List<NodePackage>>> packages = new ArrayList<Pair<NodePackage, List<NodePackage>>>();

    public ResourceManagerPackageProvider(ResourceManager resourceManager) {
        List<ResourceProvider> providers = ResourceAdapter.adapt(Minecraft.m_91087_().m_91098_().m_7536_().toList());
        providers.forEach(provider -> {
            Pair<NodePackage, List<NodePackage>> result = PackageScanner.scan(provider);
            if (result != null) {
                this.packages.add(result);
            }
        });
    }

    public void register(NodePackageLoader loader) {
        ArrayList<NodePackage> nodePackages = new ArrayList<NodePackage>();
        for (Pair<NodePackage, List<NodePackage>> aPackage : this.packages) {
            loader.addPackage(aPackage.getFirst());
            List<NodePackage> workspacePackages = aPackage.getSecond();
            if (workspacePackages == null) continue;
            nodePackages.addAll(workspacePackages);
        }
        loader.addPackages(nodePackages);
    }

    public void unregister(NodePackageLoader loader) {
        for (Pair<NodePackage, List<NodePackage>> aPackage : this.packages) {
            loader.removePackage(aPackage.getFirst());
            List<NodePackage> workspacePackages = aPackage.getSecond();
            if (workspacePackages == null) continue;
            workspacePackages.forEach(loader::removePackage);
        }
    }
}

