/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.addons.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import kasuga.lib.core.addons.resource.FlatFilesystem;
import kasuga.lib.core.addons.resource.ResourceProvider;

public class VanillaFileResourcePackProvider
implements ResourceProvider,
FlatFilesystem {
    private final ZipFile zipFile;

    public VanillaFileResourcePackProvider(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public InputStream open(String path) throws IOException {
        return this.zipFile.getInputStream(this.zipFile.getEntry("script/" + ResourceProvider.firstSplash(path)));
    }

    @Override
    public boolean exists(String path) {
        return this.zipFile.getEntry("script/" + ResourceProvider.firstSplash(path)) != null;
    }

    @Override
    public Stream<String> listEntries() {
        return this.zipFile.stream().filter(entry -> entry.getName().startsWith("script/")).map(entry -> entry.getName().substring("script/".length()));
    }

    @Override
    public boolean isRegularFile(String path) {
        return !this.zipFile.getEntry("script/" + ResourceProvider.firstSplash(path)).isDirectory();
    }

    @Override
    public boolean isDirectory(String path) {
        return this.zipFile.getEntry("script/" + ResourceProvider.firstSplash(path)).isDirectory();
    }
}

