/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.base.commands.ArgumentTypes;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import kasuga.lib.core.annos.Inner;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.FriendlyByteBuf;

@Inner
public class BaseArgument
implements ArgumentType<String> {
    public static final BaseArgument STRING = new BaseArgument(s -> s);
    public Function<String, Object> parser;

    public BaseArgument(Function<String, Object> parser) {
        this.parser = parser;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        while (reader.canRead() && reader.getString().charAt(reader.getCursor()) != ' ') {
            reader.skip();
        }
        try {
            this.parser.apply(reader.getString().substring(start, reader.getCursor()));
        }
        catch (Exception e) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)reader.getString().substring(start, reader.getCursor()));
        }
        return reader.getString().substring(start, reader.getCursor());
    }

    public static class Serializer
    implements ArgumentSerializer<BaseArgument> {
        public void serializeToNetwork(BaseArgument pArgument, FriendlyByteBuf pBuffer) {
        }

        public BaseArgument deserializeFromNetwork(FriendlyByteBuf pBuffer) {
            return STRING;
        }

        public void serializeToJson(BaseArgument pArgument, JsonObject pJson) {
        }
    }
}

