/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.util.Resources;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

@Inner
public class ModelMappings {
    public static final String IDENTIFIER = "blockstates";
    private final String namespace;
    private boolean map_finished = false;
    HashMap<ResourceLocation, ResourceLocation> map = new HashMap();

    public ModelMappings(String namespace) {
        this.namespace = namespace;
    }

    public String namespace() {
        return this.namespace;
    }

    public void map() throws IOException {
        Map<String, Resource> resources = Resources.getFullPathResources(new ResourceLocation(this.namespace, IDENTIFIER), false);
        for (String name : resources.keySet()) {
            if (!name.endsWith(".json") || !name.startsWith(IDENTIFIER)) continue;
            String plainName = IDENTIFIER + name.substring(name.lastIndexOf("/"));
            this.map.put(new ResourceLocation(this.namespace, plainName), new ResourceLocation(this.namespace, name));
            KasugaLib.MAIN_LOGGER.error("mapping block:" + name);
        }
        this.map_finished = true;
    }

    public void addMapping(ResourceLocation location0, ResourceLocation location1) {
        ResourceLocation location = new ResourceLocation(location1.m_135827_(), location1.m_135815_());
        this.map.put(location0, location);
    }

    public boolean isMapFinished() {
        return this.map_finished;
    }

    public ResourceLocation getMappings(ResourceLocation location) {
        return this.map.getOrDefault(location, location);
    }

    public boolean containsMapping(ResourceLocation location) {
        return this.map.containsKey(location);
    }
}

