/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.infrastructure;

import javax.annotation.Nonnull;
import kasuga.lib.core.client.animation.infrastructure.AnimAssignable;
import kasuga.lib.core.client.animation.infrastructure.AnimationElement;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalAssignable;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class Condition
extends AnimationElement
implements AnimAssignable {
    @Nonnull
    LogicalData data;
    private final Namespace namespace;

    public Condition(String key, Namespace namespace, String code) {
        super(key);
        this.data = namespace.decodeLogical(code);
        this.namespace = namespace;
    }

    public Condition(String key, Namespace namespace, LogicalData data) {
        super(key);
        this.data = data;
        this.namespace = namespace;
    }

    public Condition(String key, Namespace namespace, boolean data) {
        this(key, namespace, data ? "True" : "False");
    }

    public static Condition defaultTrue(String key, Namespace namespace) {
        return new Condition(key, namespace, "True");
    }

    public static Condition defaultFalse(String key, Namespace namespace) {
        return new Condition(key, namespace, "False");
    }

    public void fromString(String code) {
        this.data = this.namespace.decodeLogical(code);
    }

    public boolean result() {
        return this.data.getResult();
    }

    @NotNull
    public LogicalData getData() {
        return this.data;
    }

    @Override
    public boolean isAssignable() {
        return this.data instanceof LogicalAssignable;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void assign(String codec, float value) {
        this.namespace.assign(codec, value);
    }

    @Override
    public void init() {
    }
}

