/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import kasuga.lib.core.annos.Util;
import net.minecraft.world.phys.Vec3;

@Util
public class VectorUtil {
    public static Vec3 rot(Vector3f axis, Vec3 org, float rot, boolean degree) {
        Vector3f org3f = VectorUtil.vec3ToVec3f(org);
        Quaternion quaternion = degree ? Quaternion.m_175225_((Vector3f)org3f) : Quaternion.m_175232_((Vector3f)org3f);
        quaternion.m_80148_(degree ? axis.m_122240_(rot) : axis.m_122270_(rot));
        return VectorUtil.vec3fToVec3(degree ? quaternion.m_175227_() : quaternion.m_175217_());
    }

    public static Quaternion rotQuaternion(Quaternion org, Quaternion rot) {
        Quaternion quaternion = org.m_80161_();
        quaternion.m_80148_(rot);
        return quaternion;
    }

    public static Vec3 rot(Vec3 org, Vec3 rot, boolean degree) {
        Vector3f org3f = VectorUtil.vec3ToVec3f(org);
        Vector3f rot3f = VectorUtil.vec3ToVec3f(rot);
        Quaternion orgQ = degree ? Quaternion.m_175225_((Vector3f)org3f) : Quaternion.m_175232_((Vector3f)org3f);
        Quaternion rotQ = degree ? Quaternion.m_175225_((Vector3f)rot3f) : Quaternion.m_175232_((Vector3f)rot3f);
        orgQ.m_80148_(rotQ);
        return VectorUtil.vec3fToVec3(degree ? orgQ.m_175227_() : orgQ.m_175217_());
    }

    public static Quaternion getQuaternion(Vec3 rot, boolean degree) {
        Vector3f vector3f = VectorUtil.vec3ToVec3f(rot);
        return degree ? Quaternion.m_175225_((Vector3f)vector3f) : Quaternion.m_175232_((Vector3f)vector3f);
    }

    public static Vec3 degToRad(Vec3 deg) {
        return deg.m_82490_(Math.PI / 180);
    }

    public static Vec3 radToDeg(Vec3 rad) {
        return rad.m_82490_(57.29577951308232);
    }

    public static Vec3 rotX(Vec3 org, float rot, boolean degree) {
        return VectorUtil.rot(Vector3f.f_122223_, org, rot, degree);
    }

    public static Vec3 rotY(Vec3 org, float rot, boolean degree) {
        return VectorUtil.rot(Vector3f.f_122225_, org, rot, degree);
    }

    public static Vec3 rotZ(Vec3 org, float rot, boolean degree) {
        return VectorUtil.rot(Vector3f.f_122227_, org, rot, degree);
    }

    public static Vec3 rotXDeg(Vec3 org, float rot) {
        return VectorUtil.rotX(org, rot, true);
    }

    public static Vec3 rotYDeg(Vec3 org, float rot) {
        return VectorUtil.rotY(org, rot, true);
    }

    public static Vec3 rotZDeg(Vec3 org, float rot) {
        return VectorUtil.rotZ(org, rot, true);
    }

    public static Vec3 rotXRad(Vec3 org, float rot) {
        return VectorUtil.rotX(org, rot, false);
    }

    public static Vec3 rotYRad(Vec3 org, float rot) {
        return VectorUtil.rotY(org, rot, false);
    }

    public static Vec3 rotZRad(Vec3 org, float rot) {
        return VectorUtil.rotZ(org, rot, false);
    }

    public static void translate(PoseStack pose, Vec3 vec3) {
        pose.m_85837_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
    }

    public static void rot(PoseStack pose, Vec3 rotation, boolean degree) {
        pose.m_85845_(VectorUtil.getQuaternion(rotation, degree));
    }

    public static float translateDegAndRad(float rot, boolean toDeg) {
        return toDeg ? rot * 180.0f / (float)Math.PI : rot * (float)Math.PI / 180.0f;
    }

    public static Vec3 translateDegAndRad(Vec3 rot, boolean toDeg) {
        return toDeg ? rot.m_82490_(57.29577951308232) : rot.m_82490_(Math.PI / 180);
    }

    public static void scale(PoseStack pose, Vec3 scale) {
        pose.m_85841_((float)scale.m_7096_(), (float)scale.m_7098_(), (float)scale.m_7094_());
    }

    public static Vec3 normalize(Vec3 vec3) {
        return vec3.m_82490_(1.0 / vec3.m_82553_());
    }

    public static double cosVector(Vec3 vec1, Vec3 vec2) {
        double factor1 = vec1.m_82526_(vec2);
        double factor2 = Math.sqrt(vec2.m_82556_() * vec1.m_82556_());
        return factor1 / factor2;
    }

    public static Vec3 normalBetween(Vec3 vec1, Vec3 vec2) {
        double cosine = VectorUtil.cosVector(vec1, vec2);
        double scale = vec1.m_82553_() * cosine;
        Vec3 vec = vec2.m_82490_(scale * vec1.m_82553_() / vec2.m_82553_());
        return vec1.m_82546_(vec);
    }

    public static Vec3 mirror(Vec3 axis, Vec3 vector) {
        if (axis.m_82526_(vector) == 0.0) {
            return vector;
        }
        Vec3 normal = VectorUtil.normalBetween(vector, axis);
        return vector.m_82549_(normal.m_82490_(2.0));
    }

    public static Vector3f vec3ToVec3f(Vec3 vec3) {
        return new Vector3f(vec3);
    }

    public static Vec3 vec3fToVec3(Vector3f vector3f) {
        return new Vec3(vector3f);
    }
}

