/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.key_frame;

import kasuga.lib.core.base.NbtSerializable;
import kasuga.lib.core.client.animation.neo_neo.VectorIOUtil;
import kasuga.lib.core.client.animation.neo_neo.base.Movement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class KeyFrame<T extends Movement>
implements NbtSerializable {
    private final MovementSupplier<T> supplier;
    private float time;
    private Vec3 data;
    private int color;
    private final CompoundTag nbt;
    T cache;

    public KeyFrame(MovementSupplier<T> supplier, Vec3 data, int color, float time) {
        this.supplier = supplier;
        this.color = color;
        this.data = data;
        this.time = time;
        this.nbt = new CompoundTag();
    }

    public KeyFrame(MovementSupplier<T> supplier, Vec3 data, float time) {
        this(supplier, data, 0xFFFFFF, time);
    }

    public KeyFrame(MovementSupplier<T> supplier, Vec3 data) {
        this(supplier, data, -1.0f);
    }

    public KeyFrame(MovementSupplier<T> supplier, int color) {
        this(supplier, Vec3.f_82478_, color, -1.0f);
    }

    public KeyFrame(MovementSupplier<T> supplier) {
        this(supplier, Vec3.f_82478_);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public float getTime() {
        return this.time;
    }

    public void setData(Vec3 data) {
        this.data = data;
    }

    public Vec3 getData() {
        return this.data;
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public MovementSupplier<T> getSupplier() {
        return this.supplier;
    }

    public T create(KeyFrame<?> next) {
        Movement result = (Movement)this.supplier.get(this, next);
        this.cache = result;
        return (T)result;
    }

    public KeyFrame<T> clone() {
        return new KeyFrame<T>(this.supplier, this.data, this.color);
    }

    public T getCache() {
        return this.cache;
    }

    @Override
    public void write(CompoundTag nbt) {
        VectorIOUtil.writeVec3ToNbt(nbt, "data", this.data);
        nbt.m_128350_("time", this.time);
        nbt.m_128365_("additional", (Tag)this.nbt);
    }

    @Override
    public void read(CompoundTag nbt) {
        this.data = VectorIOUtil.getVec3FromNbt(nbt, "data");
        this.time = nbt.m_128457_("time");
        this.nbt.m_128391_(nbt.m_128469_("additional"));
    }

    public static interface MovementSupplier<T> {
        public T get(KeyFrame<?> var1, KeyFrame<?> var2);
    }
}

