/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.point;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import kasuga.lib.core.base.NbtSerializable;
import kasuga.lib.core.client.animation.neo_neo.VectorIOUtil;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class PivotPoint
implements NbtSerializable {
    private Vec3 position;
    private Vec3 rotation;
    private Quaternion cacheQ;
    boolean degree;

    public PivotPoint(Vec3 position, Vec3 rotation, boolean isDegree) {
        this.position = position;
        this.rotation = rotation;
        this.degree = isDegree;
        this.cacheQ = this.getQuaternion();
    }

    public PivotPoint(boolean isDegree) {
        this.position = Vec3.f_82478_;
        this.rotation = Vec3.f_82478_;
        this.degree = isDegree;
    }

    public PivotPoint() {
        this(true);
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vec3 getRotation() {
        return this.rotation;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    public void setRotation(Vec3 rotation) {
        this.rotation = rotation;
    }

    public void absTranslate(Vec3 offset) {
        this.position.m_82549_(offset);
    }

    public void absTranslate(double x, double y, double z) {
        this.position.m_82520_(x, y, z);
    }

    public void translate(Vec3 offset) {
        Quaternion quaternion = this.cacheQ;
        Vector3f vector3f = VectorUtil.vec3ToVec3f(offset);
        vector3f.m_122251_(quaternion);
        this.absTranslate(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
    }

    public void translate(double x, double y, double z) {
        this.translate(new Vec3(x, y, z));
    }

    public Quaternion getQuaternion() {
        return VectorUtil.getQuaternion(this.rotation, this.degree);
    }

    public boolean isDegree() {
        return this.degree;
    }

    public void setDegree(boolean isDegree) {
        if (this.degree == isDegree) {
            return;
        }
        this.rotation = VectorUtil.translateDegAndRad(this.rotation, isDegree);
    }

    public void rotate(Vec3 rotation, boolean isDegree) {
        Vec3 rot = this.degree != isDegree ? VectorUtil.translateDegAndRad(rotation, this.degree) : rotation;
        this.rotation = VectorUtil.rot(this.rotation, rot, this.degree);
        this.cacheQ = this.getQuaternion();
    }

    public PivotPoint mul(PivotPoint another) {
        Vec3 pos = this.position.m_82549_(another.position);
        Vec3 r = this.degree != another.degree ? VectorUtil.translateDegAndRad(another.rotation, this.degree) : another.rotation;
        Vec3 rot = VectorUtil.rot(this.rotation, r, this.degree);
        return new PivotPoint(pos, rot, this.degree);
    }

    public void apply(PoseStack pose) {
        VectorUtil.translate(pose, this.position);
        VectorUtil.rot(pose, this.rotation, this.degree);
    }

    public void reverseApply(PoseStack pose) {
        VectorUtil.rot(pose, this.rotation.m_82548_(), this.degree);
        VectorUtil.translate(pose, this.position.m_82548_());
    }

    @Override
    public void write(CompoundTag nbt) {
        VectorIOUtil.writeVec3ToNbt(nbt, "pos", this.position);
        VectorIOUtil.writeVec3ToNbt(nbt, "rot", this.rotation);
        nbt.m_128379_("degree", this.degree);
    }

    @Override
    public void read(CompoundTag nbt) {
        this.position = VectorIOUtil.getVec3FromNbt(nbt, "pos");
        this.rotation = VectorIOUtil.getVec3FromNbt(nbt, "rot");
        this.degree = nbt.m_128471_("degree");
    }
}

