/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.rotation;

import java.util.LinkedList;
import java.util.List;
import kasuga.lib.core.client.animation.neo_neo.InterpolationUtil;
import kasuga.lib.core.client.animation.neo_neo.VectorIOUtil;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import kasuga.lib.core.client.animation.neo_neo.base.IBezier;
import kasuga.lib.core.client.animation.neo_neo.rotation.Rotation;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class BezierRotation
extends Rotation
implements IBezier {
    private final List<Vec3> bezierPoints = new LinkedList<Vec3>();
    Pair<Float, Vec3> cache = Pair.of(Float.valueOf(0.0f), Vec3.f_82478_);

    public BezierRotation(Vec3 data, float startTime, float endTime, boolean degree) {
        super(data, startTime, endTime, degree);
    }

    public void rotX(float rot, boolean deg) {
        this.data = VectorUtil.rotX(this.data, this.transform(rot, deg), this.isDegree());
    }

    public void rotY(float rot, boolean deg) {
        this.data = VectorUtil.rotY(this.data, this.transform(rot, deg), this.isDegree());
    }

    public void rotZ(float rot, boolean deg) {
        this.data = VectorUtil.rotZ(this.data, this.transform(rot, deg), this.isDegree());
    }

    @Override
    public void reset() {
        super.reset();
        this.bezierPoints.clear();
        this.cache = Pair.of(Float.valueOf(0.0f), Vec3.f_82478_);
    }

    public float transform(float rot, boolean deg) {
        if (deg == this.isDegree()) {
            return rot;
        }
        return VectorUtil.translateDegAndRad(rot, !deg);
    }

    @Override
    public Vec3 getPercentage(float percentage) {
        if (this.cache.getFirst().equals(Float.valueOf(percentage))) {
            return this.cache.getSecond();
        }
        Vec3 result = InterpolationUtil.bezier(Vec3.f_82478_, this.data, this.bezierPoints, percentage);
        this.cache = Pair.of(Float.valueOf(percentage), result);
        return result;
    }

    @Override
    public List<Vec3> getBezierPoints() {
        return this.bezierPoints;
    }

    @Override
    public Vec3 getMovementVector() {
        return this.getData();
    }

    @Override
    public void createDefaultBezier(IBezier before) {
        InterpolationUtil.createDefaultBezier(before, this, 0.33333334f);
    }

    @Override
    public void write(CompoundTag nbt) {
        super.write(nbt);
        VectorIOUtil.writeVec3ListToNbt(nbt, "bezier", this.bezierPoints);
    }

    @Override
    public void read(CompoundTag nbt) {
        super.read(nbt);
        this.bezierPoints.clear();
        this.bezierPoints.addAll(VectorIOUtil.getVec3ListFromNbt(nbt, "bezier"));
    }
}

