/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.translation;

import com.mojang.blaze3d.vertex.PoseStack;
import kasuga.lib.core.client.animation.neo_neo.InterpolationUtil;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import kasuga.lib.core.client.animation.neo_neo.base.ICustom;
import kasuga.lib.core.client.animation.neo_neo.point.PivotPoint;
import kasuga.lib.core.client.animation.neo_neo.translation.Translation;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.interpreter.Code;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class CustomTranslation
extends Translation
implements ICustom {
    private Pair<Float, Vec3> cache;
    private final Namespace namespace;
    private Formula x;
    private Formula y;
    private Formula z;

    public CustomTranslation(Namespace namespace, String x, String y, String z, float startTime, float endTime) {
        super(Vec3.f_82478_, startTime, endTime);
        this.namespace = namespace;
        this.x = namespace.decodeFormula(x);
        this.y = namespace.decodeFormula(y);
        this.z = namespace.decodeFormula(z);
        this.updateMovement();
        this.cache = Pair.of(Float.valueOf(startTime), Vec3.f_82478_);
        namespace.assign("start_time", startTime);
        namespace.assign("end_time", endTime);
    }

    public CustomTranslation(String x, String y, String z, float startTime, float endTime) {
        this(new Namespace(Code.ROOT_NAMESPACE), x, y, z, startTime, endTime);
    }

    public CustomTranslation(Namespace namespace, float startTime, float endTime) {
        this(namespace, "0", "0", "0", startTime, endTime);
    }

    public CustomTranslation(float startTime, float endTime) {
        this("0", "0", "0", startTime, endTime);
    }

    public void updateMovement() {
        float t = this.namespace.getInstance("t").getValue("t");
        this.namespace.assign("t", 1.0f);
        this.setData(new Vec3((double)this.x.getResult(), (double)this.y.getResult(), (double)this.z.getResult()));
        this.namespace.assign("t", t);
    }

    public Pair<Float, Vec3> getCache() {
        return this.cache;
    }

    @Override
    public void setX(String x) {
        this.x = this.namespace.decodeFormula(x);
        this.updateMovement();
    }

    @Override
    public void setY(String y) {
        this.y = this.namespace.decodeFormula(y);
        this.updateMovement();
    }

    @Override
    public void setZ(String z) {
        this.z = this.namespace.decodeFormula(z);
        this.updateMovement();
    }

    @Override
    public Formula getX() {
        return this.x;
    }

    @Override
    public Formula getY() {
        return this.y;
    }

    @Override
    public Formula getZ() {
        return this.z;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public void setStartTime(float startTime) {
        super.setStartTime(startTime);
        this.namespace.assign("start_time", startTime);
    }

    @Override
    public void setEndTime(float endTime) {
        super.setEndTime(endTime);
        this.namespace.assign("end_time", endTime);
    }

    @Override
    public void reset() {
        super.reset();
        this.x = this.namespace.decodeFormula("0");
        this.y = this.namespace.decodeFormula("0");
        this.z = this.namespace.decodeFormula("0");
        this.cache = Pair.of(Float.valueOf(0.0f), Vec3.f_82478_);
    }

    @Override
    public Vec3 getPercentage(float percentage) {
        if (this.cache.getFirst().equals(Float.valueOf(percentage))) {
            return this.cache.getSecond();
        }
        Vec3 result = InterpolationUtil.custom(this.namespace, this.x, this.y, this.z, percentage);
        this.cache = Pair.of(Float.valueOf(percentage), result);
        return result;
    }

    @Override
    public void move(float time, PoseStack pose) {
        VectorUtil.translate(pose, this.getPercentage(time));
    }

    @Override
    public void apply(PivotPoint point, float time) {
        point.translate(this.getPercentage(time));
    }

    @Override
    public void read(CompoundTag nbt) {
        super.read(nbt);
        this.readCustomFormulas(nbt, "custom");
    }

    @Override
    public void write(CompoundTag nbt) {
        super.write(nbt);
        this.writeCustomFormulas(nbt, "custom");
    }
}

