/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.addons.node.PackageScanner;
import kasuga.lib.core.client.frontend.commands.MetroLoaderModule;
import kasuga.lib.core.client.frontend.commands.MetroServerModule;
import kasuga.lib.core.client.frontend.commands.MetroServerResourceProvider;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.JavascriptThread;
import kasuga.lib.core.javascript.module.JavascriptModule;
import kasuga.lib.core.javascript.module.ModuleLoader;
import kasuga.lib.core.javascript.module.node.CommonJSUtils;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.exception.AbstractTruffleException;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Source;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Value;

public class MetroModuleLoader
implements ModuleLoader {
    @Override
    public Optional<JavascriptModule> load(JavascriptModule source, String name) {
        if (source instanceof MetroLoaderModule) {
            MetroLoaderModule loaderModule = (MetroLoaderModule)source;
            return this.loaderLoad(loaderModule, name);
        }
        if (!(source instanceof MetroServerModule)) {
            return Optional.empty();
        }
        MetroServerModule metroModule = (MetroServerModule)source;
        String path = name.startsWith("/") ? name : PackageScanner.joinPath(PackageScanner.resolve(PackageScanner.splitPath(metroModule.relativePath), PackageScanner.splitPath(name)));
        return this.load(path, metroModule.getServerAddress(), metroModule.getProvider(), metroModule.getContext());
    }

    private Optional<JavascriptModule> loaderLoad(MetroLoaderModule loaderModule, String name) {
        return this.load(name, loaderModule.getServerAddress(), loaderModule.getProvider(), loaderModule.getContext());
    }

    protected Optional<JavascriptModule> load(String path, String serverAddress, MetroServerResourceProvider provider, JavascriptContext context) {
        Optional<JavascriptModule> optional;
        block9: {
            if (((String)path).endsWith(".bundle")) {
                path = (String)path + "?platform=minecraft";
            }
            InputStream stream = provider.open((String)path);
            try {
                InputStreamReader reader = new InputStreamReader(stream);
                Reader parsedResource = CommonJSUtils.transform(reader);
                Source source = Source.newBuilder("js", parsedResource, (String)path).build();
                List<String> parsedPath = PackageScanner.splitPath((String)path);
                Value sourceValue = context.execute(source);
                MetroServerModule module = new MetroServerModule(context, sourceValue, serverAddress, PackageScanner.joinPath(parsedPath.subList(1, parsedPath.size() - 1)), provider);
                optional = Optional.of(module);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | AbstractTruffleException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    public static void init() {
        KasugaLib.STACKS.JAVASCRIPT.GROUP_CLIENT.getModuleLoader().getLoader().register(new MetroModuleLoader());
    }

    public static JavascriptThread getThread() {
        return KasugaLib.STACKS.JAVASCRIPT.GROUP_CLIENT.getOrCreate(MetroModuleLoader.class, "Metro Server Thread");
    }
}

