/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.common.layouting;

import java.util.Objects;
import java.util.WeakHashMap;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBox;
import kasuga.lib.core.util.LazyRecomputable;

public class LayoutCache {
    public LayoutCache tracking = null;
    public WeakHashMap<LayoutCache, Boolean> updated = new WeakHashMap();
    public LayoutBox engineCoordinate = LayoutBox.ZERO;
    public CacheFunction cacheFunction = CacheFunction.DEFAULT;
    public LazyRecomputable<LayoutBox> screenCoordinate = LazyRecomputable.predictable(() -> {
        if (this.tracking != null) {
            this.tracking.notifyUpdated(this);
        }
        this.updated.clear();
        return this.cacheFunction.get(this.tracking, this.engineCoordinate);
    }, () -> this.tracking == null || !this.tracking.shouldUpdate(this));

    private void notifyUpdated(LayoutCache layoutCache) {
        this.updated.put(layoutCache, false);
    }

    private boolean shouldUpdate(LayoutCache layoutCache) {
        return this.updated.getOrDefault(layoutCache, true);
    }

    public void setTracking(LayoutCache tracking) {
        if (tracking == this.tracking) {
            return;
        }
        this.tracking = tracking;
        this.screenCoordinate.clear();
    }

    public void setCacheFunction(CacheFunction cacheFunction) {
        if (cacheFunction == this.cacheFunction) {
            return;
        }
        this.cacheFunction = cacheFunction;
        this.screenCoordinate.clear();
    }

    public void setEngineCoordinate(LayoutBox engineCoordinate) {
        if (Objects.equals(engineCoordinate, this.engineCoordinate)) {
            return;
        }
        this.engineCoordinate = engineCoordinate;
        this.screenCoordinate.clear();
    }

    @FunctionalInterface
    public static interface CacheFunction {
        public static final CacheFunction DEFAULT = new CacheFunction(){

            @Override
            public LayoutBox get(LayoutCache tracking, LayoutBox engineCoordinate) {
                LayoutBox trackingScreenCoordinate = tracking == null ? LayoutBox.ZERO : tracking.screenCoordinate.get();
                return engineCoordinate.addCoordinateFrom(trackingScreenCoordinate);
            }
        };

        public LayoutBox get(LayoutCache var1, LayoutBox var2);
    }
}

