/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.dom.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Value;

public class EventEmitter {
    HashMap<String, Set<Consumer<Value>>> listeners = new HashMap();
    HashMap<String, Set<Value>> functionalListeners = new HashMap();

    public UnsubscribeHandler subscribe(String eventName, Consumer<Value> consumer) {
        this.listeners.computeIfAbsent(eventName, v -> new HashSet()).add(consumer);
        return () -> this.unsubscribe(eventName, consumer);
    }

    public void unsubscribe(String eventName, Consumer<Value> consumer) {
        this.listeners.computeIfPresent(eventName, (name, data) -> {
            data.remove(consumer);
            return data.isEmpty() ? null : data;
        });
    }

    public void subscribe(String eventName, Value consumer) {
        this.functionalListeners.computeIfAbsent(eventName, v -> new HashSet()).add(consumer);
    }

    public void unsubscribe(String eventName, Value consumer) {
        this.functionalListeners.computeIfPresent(eventName, (name, data) -> {
            data.remove(consumer);
            return data.isEmpty() ? null : data;
        });
    }

    public void dispatchEvent(String eventName, Value event) {
        Set<Consumer<Value>> consumers = this.listeners.get(eventName);
        if (consumers != null) {
            ArrayList<Consumer<Value>> temporaryConsumer = new ArrayList<Consumer<Value>>(consumers);
            for (Consumer consumer : temporaryConsumer) {
                consumer.accept(event);
            }
        }
        if (this.functionalListeners.containsKey(eventName)) {
            ArrayList functionalConsumers = new ArrayList(this.functionalListeners.get(eventName));
            for (Value value : functionalConsumers) {
                value.executeVoid(event);
            }
        }
    }

    public static interface UnsubscribeHandler {
        public void unsubscribe();
    }
}

