/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.dom.nodes;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import kasuga.lib.core.client.frontend.dom.DomContext;
import kasuga.lib.core.client.frontend.dom.attribute.AttributeMap;
import kasuga.lib.core.client.frontend.dom.event.EventEmitter;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.HostAccess;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Value;

public class DomNode<T extends DomContext<?, ?>> {
    protected final T domContext;
    JavascriptContext context;
    public DomNode<T> parent;
    public List<DomNode<T>> children = new CopyOnWriteArrayList<DomNode<T>>();
    protected AttributeMap attributes = new AttributeMap();
    protected EventEmitter emitter = new EventEmitter();
    HashMap<Value, Consumer<Value>> callbacks = new HashMap();

    public DomNode(T context) {
        this.domContext = context;
    }

    public boolean addChildAt(int i, DomNode<T> child) {
        if (child.parent != null) {
            return false;
        }
        if (this.children.contains(child)) {
            return false;
        }
        this.children.add(i, child);
        child.parent = this;
        return true;
    }

    @HostAccess.Export
    public boolean addChild(DomNode<T> child) {
        return this.addChildAt(this.children.size(), child);
    }

    @HostAccess.Export
    public boolean removeChild(DomNode<T> child) {
        boolean resp = this.children.remove(child);
        if (resp) {
            child.parent = null;
        }
        return resp;
    }

    public void clear() {
        for (DomNode<T> child : this.children) {
            child.parent = null;
        }
        this.children.clear();
    }

    @HostAccess.Export
    public void addEventListener(String eventName, Value callback) {
        callback.pin();
        this.emitter.subscribe(eventName, callback);
    }

    @HostAccess.Export
    public void removeEventListener(String eventName, Value callback) {
        this.emitter.unsubscribe(eventName, callback);
    }

    @HostAccess.Export
    public void dispatchEvent(String eventName, Value event) {
        this.emitter.dispatchEvent(eventName, event);
    }

    @HostAccess.Export
    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, String value) {
        this.attributes.set(attributeName, value);
    }

    @HostAccess.Export
    public void setAttribute(String attributeName, Value value) {
        this.setAttribute(attributeName, value.asString());
    }

    public void render(Object source, RenderContext context) {
        for (DomNode<T> child : this.children) {
            child.render(source, context);
        }
    }

    public T getDomContext() {
        return this.domContext;
    }

    public void close() {
    }

    @HostAccess.Export
    public boolean hasFeature(String feature) {
        return false;
    }
}

