/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui;

import java.util.HashSet;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.frontend.assets.TextureAssetProvider;
import kasuga.lib.core.client.frontend.dom.nodes.NodeTypeRegistry;
import kasuga.lib.core.client.frontend.dom.registration.DOMPriorityRegistry;
import kasuga.lib.core.client.frontend.gui.GuiContext;
import kasuga.lib.core.client.frontend.gui.GuiInstance;
import kasuga.lib.core.client.frontend.gui.nodes.AllGuiNodes;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomNode;
import kasuga.lib.core.client.frontend.gui.styles.AllGuiStyles;
import kasuga.lib.core.client.frontend.gui.styles.GuiStyleRegistry;
import kasuga.lib.core.client.frontend.rendering.ImageProviders;
import net.minecraft.resources.ResourceLocation;

public class GuiEngine {
    public final DOMPriorityRegistry domRegistry = new DOMPriorityRegistry();
    public final NodeTypeRegistry<GuiDomNode> nodeTypeRegistry = new NodeTypeRegistry();
    public final GuiStyleRegistry styleRegistry = new GuiStyleRegistry();
    public HashSet<GuiInstance> instances = new HashSet();

    public void init() {
        KasugaLib.STACKS.JAVASCRIPT.registry.register(new ResourceLocation("kasuga_lib", "gui"), this.domRegistry);
        TextureAssetProvider.init();
        AllGuiStyles.register(this.styleRegistry);
        AllGuiNodes.register(this.nodeTypeRegistry);
        ImageProviders.init();
    }

    public GuiInstance create(ResourceLocation location) {
        GuiInstance instance = new GuiInstance(location);
        this.instances.add(instance);
        return instance;
    }

    public void closeInstance(GuiInstance instance) {
        this.instances.remove(instance);
    }

    public void renderTick() {
        for (GuiInstance instance : this.instances) {
            instance.getContext().ifPresent(GuiContext::renderTick);
        }
    }
}

