/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles;

import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaEdge;
import kasuga.lib.core.client.frontend.gui.styles.GuiStyleRegistry;
import kasuga.lib.core.client.frontend.gui.styles.PixelUnit;
import kasuga.lib.core.client.frontend.gui.styles.layout.AlignType;
import kasuga.lib.core.client.frontend.gui.styles.layout.BorderStyle;
import kasuga.lib.core.client.frontend.gui.styles.layout.DisplayType;
import kasuga.lib.core.client.frontend.gui.styles.layout.EnumStyle;
import kasuga.lib.core.client.frontend.gui.styles.layout.FlexDirection;
import kasuga.lib.core.client.frontend.gui.styles.layout.JustifyType;
import kasuga.lib.core.client.frontend.gui.styles.layout.PositionStyle;
import kasuga.lib.core.client.frontend.gui.styles.layout.PositionType;
import kasuga.lib.core.client.frontend.gui.styles.layout.SizeStyle;
import kasuga.lib.core.client.frontend.gui.styles.node.BackgroundImageStyle;
import kasuga.lib.core.client.frontend.gui.styles.node.BackgroundNineSliceParam;
import kasuga.lib.core.client.frontend.gui.styles.node.BackgroundRenderTypeStyle;
import kasuga.lib.core.client.frontend.gui.styles.node.BackgroundUVStyle;
import kasuga.lib.core.client.frontend.gui.styles.node.FontSizeStyle;

public class AllGuiStyles {
    public static void register(GuiStyleRegistry styleRegistry) {
        styleRegistry.register("top", PositionStyle.createType(YogaEdge.TOP));
        styleRegistry.register("left", PositionStyle.createType(YogaEdge.LEFT));
        styleRegistry.register("right", PositionStyle.createType(YogaEdge.RIGHT));
        styleRegistry.register("bottom", PositionStyle.createType(YogaEdge.BOTTOM));
        styleRegistry.register("width", SizeStyle.createType((n, v) -> {
            switch ((PixelUnit)((Object)((Object)v.getSecond()))) {
                case NATIVE: {
                    n.setWidth(((Float)v.getFirst()).floatValue());
                    break;
                }
                case PERCENTAGE: {
                    n.setWidthPercent(((Float)v.getFirst()).floatValue());
                }
            }
        }));
        styleRegistry.register("height", SizeStyle.createType((n, v) -> {
            switch ((PixelUnit)((Object)((Object)v.getSecond()))) {
                case NATIVE: {
                    n.setHeight(((Float)v.getFirst()).floatValue());
                    break;
                }
                case PERCENTAGE: {
                    n.setHeightPercent(((Float)v.getFirst()).floatValue());
                }
            }
        }));
        styleRegistry.register("displayType", EnumStyle.EnumStyleType.of(DisplayType::fromString, (v, i) -> v != DisplayType.INVALID, v -> StyleTarget.LAYOUT_NODE.create(node -> node.setDisplay(v.getValue())), DisplayType.UNSET));
        styleRegistry.register("positionType", EnumStyle.EnumStyleType.of(PositionType::fromString, (v, i) -> v != PositionType.INVALID, v -> StyleTarget.LAYOUT_NODE.create(node -> node.setPositionType(v.getValue())), PositionType.ABSOLUTE));
        styleRegistry.register("alignContent", EnumStyle.EnumStyleType.of(AlignType::fromString, (v, i) -> v != AlignType.INVALID, v -> StyleTarget.LAYOUT_NODE.create(node -> node.setAlignContent(v.getValue())), AlignType.AUTO));
        styleRegistry.register("alignSelf", EnumStyle.EnumStyleType.of(AlignType::fromString, (v, i) -> v != AlignType.INVALID, v -> StyleTarget.LAYOUT_NODE.create(node -> node.setAlignSelf(v.getValue())), AlignType.AUTO));
        styleRegistry.register("alignItems", EnumStyle.EnumStyleType.of(AlignType::fromString, (v, i) -> v != AlignType.INVALID, v -> StyleTarget.LAYOUT_NODE.create(node -> node.setAlignItems(v.getValue())), AlignType.AUTO));
        styleRegistry.register("justifyContent", EnumStyle.EnumStyleType.of(JustifyType::fromString, (v, i) -> v != JustifyType.INVALID, v -> StyleTarget.LAYOUT_NODE.create(node -> node.setJustifyContent(v.getValue())), JustifyType.FLEX_START));
        styleRegistry.register("flexDirection", EnumStyle.EnumStyleType.of(FlexDirection::fromString, (v, i) -> v != FlexDirection.INVALID, v -> StyleTarget.LAYOUT_NODE.create(node -> node.setFlexDirection(v.getValue())), FlexDirection.INVALID));
        styleRegistry.register("flexBasis", SizeStyle.createType((n, v) -> {
            switch ((PixelUnit)((Object)((Object)v.getSecond()))) {
                case NATIVE: {
                    n.setFlexBasis(((Float)v.getFirst()).floatValue());
                    break;
                }
                case PERCENTAGE: {
                    n.setFlexBasisPercent(((Float)v.getFirst()).floatValue());
                }
            }
        }));
        styleRegistry.register("borderTop", BorderStyle.createType(YogaEdge.TOP));
        styleRegistry.register("borderLeft", BorderStyle.createType(YogaEdge.LEFT));
        styleRegistry.register("borderRight", BorderStyle.createType(YogaEdge.RIGHT));
        styleRegistry.register("borderBottom", BorderStyle.createType(YogaEdge.BOTTOM));
        styleRegistry.register("marginTop", SizeStyle.createType((n, v) -> {
            switch ((PixelUnit)((Object)((Object)v.getSecond()))) {
                case NATIVE: {
                    n.setMargin(YogaEdge.TOP, ((Float)v.getFirst()).floatValue());
                    break;
                }
                case PERCENTAGE: {
                    n.setMarginPercent(YogaEdge.TOP, ((Float)v.getFirst()).floatValue());
                }
            }
        }));
        styleRegistry.register("marginLeft", SizeStyle.createType((n, v) -> {
            switch ((PixelUnit)((Object)((Object)v.getSecond()))) {
                case NATIVE: {
                    n.setMargin(YogaEdge.LEFT, ((Float)v.getFirst()).floatValue());
                    break;
                }
                case PERCENTAGE: {
                    n.setMarginPercent(YogaEdge.LEFT, ((Float)v.getFirst()).floatValue());
                }
            }
        }));
        styleRegistry.register("marginRight", SizeStyle.createType((n, v) -> {
            switch ((PixelUnit)((Object)((Object)v.getSecond()))) {
                case NATIVE: {
                    n.setMargin(YogaEdge.RIGHT, ((Float)v.getFirst()).floatValue());
                    break;
                }
                case PERCENTAGE: {
                    n.setMarginPercent(YogaEdge.RIGHT, ((Float)v.getFirst()).floatValue());
                }
            }
        }));
        styleRegistry.register("marginBottom", SizeStyle.createType((n, v) -> {
            switch ((PixelUnit)((Object)((Object)v.getSecond()))) {
                case NATIVE: {
                    n.setMargin(YogaEdge.BOTTOM, ((Float)v.getFirst()).floatValue());
                    break;
                }
                case PERCENTAGE: {
                    n.setMarginPercent(YogaEdge.BOTTOM, ((Float)v.getFirst()).floatValue());
                }
            }
        }));
        styleRegistry.register("backgroundUV", BackgroundUVStyle.TYPE);
        styleRegistry.register("backgroundImage", BackgroundImageStyle.TYPE);
        styleRegistry.register("backgroundRenderType", BackgroundRenderTypeStyle.TYPE);
        styleRegistry.register("backgroundNineSliceParam", BackgroundNineSliceParam.TYPE);
        styleRegistry.register("fontSize", FontSizeStyle.TYPE);
    }
}

