/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.font;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.function.Consumer;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.font.Font;
import kasuga.lib.core.client.render.texture.Vec2f;
import kasuga.lib.core.util.ComponentHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;

public class TextContext {
    private final Font font;
    private Style style;
    private final Component text;
    private SimpleColor color;
    private Vec2f scale;
    private Vec2f pivot;
    private Vector3f rotation;
    public static final Vec2f ONE = new Vec2f(1.0f, 1.0f);

    public TextContext(Font font, Component component) {
        this.font = font;
        this.text = component;
        this.scale = ONE;
        this.pivot = Vec2f.ZERO;
        this.rotation = Vector3f.f_176763_;
        this.style = null;
    }

    public TextContext(Component component) {
        this(null, component);
    }

    public TextContext(Font font, String text) {
        this(font, ComponentHelper.literal(text));
    }

    public TextContext(String text) {
        this(null, text);
    }

    public Vec2f getPivot() {
        return this.pivot;
    }

    public void setPivot(Vec2f pivot) {
        this.pivot = pivot;
    }

    public void setPivot(float px, float py) {
        this.pivot = new Vec2f(px, py);
    }

    public void setScale(Vec2f scale) {
        this.scale = scale;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scale.setX(scaleX);
        this.scale.setY(scaleY);
    }

    public Vec2f getScale() {
        return this.scale;
    }

    public float getScaleX() {
        return this.scale.x();
    }

    public float getScaleY() {
        return this.scale.y();
    }

    public float getWidth() {
        this.getFont().m_131146_(this.text.m_7383_());
        return (float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text) * this.scale.x();
    }

    public float getHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9.0f * this.scale.y();
    }

    public void setColor(SimpleColor color) {
        this.color = color;
    }

    public SimpleColor getColor() {
        return this.color;
    }

    public Component getText() {
        return this.text;
    }

    public Style getFont() {
        if (this.style != null) {
            return this.style;
        }
        if (this.font == null) {
            this.style = Style.f_131099_;
            return this.style;
        }
        this.style = this.font.getFont();
        return this.style;
    }

    public void resetFont() {
        this.style = null;
        this.getFont();
    }

    public void rotate(Vector3f rotation) {
        Quaternion quaternion = Quaternion.m_175232_((Vector3f)this.rotation);
        Quaternion other = Quaternion.m_175232_((Vector3f)rotation);
        quaternion.m_80148_(other);
        this.rotation = quaternion.m_175217_();
    }

    public void rotateDeg(Vector3f rotationDeg) {
        rotationDeg = rotationDeg.m_122281_();
        rotationDeg.m_122261_((float)Math.PI / 180);
        this.rotate(rotationDeg);
    }

    public void rotate(float x, float y, float z) {
        this.rotate(new Vector3f(x, y, z));
    }

    public void rotateDeg(float x, float y, float z) {
        this.rotateDeg(new Vector3f(x, y, z));
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public void setRotation(float x, float y, float z) {
        this.rotation = new Vector3f(x, y, z);
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void setInsertion(String insertion) {
        this.getFont().m_131138_(insertion);
    }

    public void setClickEvent(ClickEvent clickEvent) {
        this.getFont().m_131142_(clickEvent);
    }

    public void setHoverEvent(HoverEvent event) {
        this.getFont().m_131144_(event);
    }

    public void applyFormat(ChatFormatting ... formats) {
        this.getFont().m_131152_(formats);
    }

    public boolean isUnderlined() {
        return this.getFont().m_131171_();
    }

    public void underline(boolean underline) {
        this.getFont().m_131162_(Boolean.valueOf(underline));
    }

    public void bold(boolean bold) {
        this.getFont().m_131136_(Boolean.valueOf(bold));
    }

    public boolean isBold() {
        return this.getFont().m_131154_();
    }

    public void strikeThrough(boolean strikeThrough) {
        this.getFont().m_178522_(Boolean.valueOf(strikeThrough));
    }

    public boolean isStrikeThrough() {
        return this.getFont().m_131168_();
    }

    public void obfuscated(boolean obfuscated) {
        this.getFont().m_178524_(Boolean.valueOf(obfuscated));
    }

    public boolean isObfuscated() {
        return this.getFont().m_131176_();
    }

    public void italic(boolean italic) {
        this.getFont().m_131155_(Boolean.valueOf(italic));
    }

    public void renderToGui(PoseStack pose) {
        this.transform(pose, obj -> Minecraft.m_91087_().f_91062_.m_92889_(pose, this.text, 0.0f, 0.0f, this.color.getRGB()));
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource source, boolean dropShadow, boolean transparent, SimpleColor bgColor, int light) {
        this.transform(pose, obj -> Minecraft.m_91087_().f_91062_.m_92841_(this.text, 0.0f, 0.0f, this.color.getRGB(), dropShadow, pose.m_85850_().m_85861_(), source, transparent, bgColor.getRGB(), light));
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource source, boolean dropShadow, int light) {
        this.renderToWorld(pose, source, dropShadow, true, SimpleColor.fromRGBA(0, 0, 0, 0), light);
    }

    public void renderToWorld(PoseStack pose, MultiBufferSource source, int light) {
        this.renderToWorld(pose, source, false, light);
    }

    private void transform(PoseStack pose, Consumer<Object> func) {
        pose.m_85845_(Quaternion.m_175232_((Vector3f)this.rotation));
        pose.m_85841_(this.scale.x(), this.scale.y(), 1.0f);
        pose.m_85837_((double)(-this.pivot.x() * this.getWidth()), (double)(-this.pivot.y() * this.getHeight()), 0.0);
        func.accept(null);
        pose.m_85837_((double)(this.pivot.x() * this.getWidth()), (double)(this.pivot.y() * this.getHeight()), 0.0);
        pose.m_85841_(1.0f / this.scale.x(), 1.0f / this.scale.y(), 1.0f);
        Vector3f negRot = this.rotation.m_122281_();
        negRot.m_122261_(-1.0f);
        pose.m_85845_(Quaternion.m_175232_((Vector3f)negRot));
    }
}

