/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kasuga.lib.core.client.render.model.SimpleModel;
import kasuga.lib.registrations.client.ModelReg;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiPartModel
extends SimpleModel {
    private final HashMap<String, SimpleModel> bones;
    public StaticMovements staticMovements;

    public MultiPartModel(@NotNull String key) {
        super(key, null);
        this.bones = new HashMap();
    }

    public MultiPartModel(@NotNull String key, HashMap<String, SimpleModel> bones) {
        super(key, null);
        this.bones = (HashMap)Map.copyOf(bones);
    }

    public MultiPartModel(@NotNull ModelReg reg) {
        this(reg.registrationKey);
    }

    @Override
    public void copyModelFrom(SimpleModel model) {
        if (model instanceof MultiPartModel) {
            MultiPartModel multiPartModel = (MultiPartModel)model;
            this.bones.putAll(multiPartModel.bones);
        } else {
            this.bones.put(model.key, model);
        }
    }

    public void addBoneByPath(String path, SimpleModel bone) {
        boolean flag;
        boolean bl = flag = path.lastIndexOf(".") == -1;
        if (flag) {
            this.addBone(bone);
        } else {
            String p = path.substring(0, path.lastIndexOf("."));
            MultiPartModel multiPartModel = this.getOrCreate(p);
            multiPartModel.addBone(bone);
        }
    }

    public MultiPartModel getOrCreate(String path) {
        return this.getOrCreate(path.split("\\."), 0);
    }

    private MultiPartModel getOrCreate(String[] paths, int index) {
        if (index < paths.length && index > -1) {
            SimpleModel model;
            boolean flag = this.containsBone(paths[index]);
            SimpleModel simpleModel = model = flag ? this.getBone(paths[index]) : null;
            if (!(model instanceof MultiPartModel)) {
                MultiPartModel subModel = new MultiPartModel(paths[index]);
                if (flag) {
                    subModel.addBone(model);
                    this.bones.remove(paths[index]);
                }
                this.addBone(subModel);
                if (index < paths.length - 1) {
                    return subModel.getOrCreate(paths, index + 1);
                }
                return subModel;
            }
            if (index < paths.length - 1) {
                return ((MultiPartModel)model).getOrCreate(paths, index + 1);
            }
            return (MultiPartModel)model;
        }
        return null;
    }

    @Nullable
    public SimpleModel getBoneByPath(String path) {
        if (path.lastIndexOf(".") == -1) {
            return this.containsBone(path) ? this.getBone(path) : null;
        }
        return this.getBoneByPath(path.split("\\."), 0);
    }

    private SimpleModel getBoneByPath(String[] paths, int index) {
        if (index < paths.length && index > -1) {
            SimpleModel model;
            boolean flag = this.containsBone(paths[index]);
            SimpleModel simpleModel = model = flag ? this.getBone(paths[index]) : null;
            if (!(model instanceof MultiPartModel)) {
                return null;
            }
            if (index < paths.length - 1) {
                return ((MultiPartModel)model).getBoneByPath(paths, index + 1);
            }
            return model;
        }
        return null;
    }

    public void setRenderTypeFor(String bonePath, SimpleModel.RenderTypeBuilder builder) {
        SimpleModel model = this.getBoneByPath(bonePath);
        if (model != null) {
            model.renderType(builder);
        }
    }

    public boolean containsBone(String boneKey) {
        return this.bones.containsKey(boneKey);
    }

    public SimpleModel getBone(String boneKey) {
        return this.bones.getOrDefault(boneKey, null);
    }

    public Map<String, SimpleModel> getBoneMap() {
        return this.bones;
    }

    public void applyParentRenderTypeForBone(String bonePath) {
        SimpleModel model = this.getBoneByPath(bonePath);
        if (this.builder != null && model != null) {
            this.setRenderTypeFor(bonePath, this.builder);
        }
    }

    public void applyParentRenderTypeForAllBones() {
        if (this.builder != null) {
            for (String key : this.bones.keySet()) {
                SimpleModel b = this.bones.get(key);
                b.renderType(this.builder);
                if (!(b instanceof MultiPartModel)) continue;
                MultiPartModel multiPartModel = (MultiPartModel)b;
                multiPartModel.applyParentRenderTypeForAllBones();
            }
        }
    }

    public void translateBone(String boneKey, double x, double y, double z) {
        if (this.containsBone(boneKey)) {
            this.bones.get(boneKey).translate(x, y, z);
        }
    }

    public void rotateXForBone(String boneKey, float xRot) {
        if (this.containsBone(boneKey)) {
            this.getBone(boneKey).rotateX(xRot);
        }
    }

    public void rotateYForBone(String boneKey, float yRot) {
        if (this.containsBone(boneKey)) {
            this.getBone(boneKey).rotateY(yRot);
        }
    }

    public void rotateZForBone(String boneKey, float zRot) {
        if (this.containsBone(boneKey)) {
            this.getBone(boneKey).rotateX(zRot);
        }
    }

    public void addBone(SimpleModel model) {
        this.bones.put(model.key, model);
    }

    public void addAllBones(SimpleModel ... models) {
        for (SimpleModel model : models) {
            this.addBone(model);
        }
    }

    public Set<String> getAllKeys() {
        return this.getBoneMap().keySet();
    }

    public void setStaticMovements(StaticMovements movements) {
        this.staticMovements = movements;
    }

    public void removeBone(String key) {
        this.bones.remove(key);
    }

    public void removeBones(String ... keys) {
        for (String key : keys) {
            this.removeBone(key);
        }
    }

    public void removeAllBones() {
        this.bones.clear();
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource source, float x, float y, float z, int light, int overlay) {
        if (!this.shouldRender) {
            return;
        }
        if (this.builder == null) {
            return;
        }
        if (this.cacheType == null) {
            this.cacheType = this.builder.build();
        }
        boolean shouldPush = pose.m_85851_();
        Matrix4f lastMatrix = null;
        if (shouldPush) {
            lastMatrix = pose.m_85850_().m_85861_();
            pose.m_85849_();
        }
        pose.m_85836_();
        if (this.useParentPose && lastMatrix != null) {
            pose.m_166854_(lastMatrix);
        }
        if (this.staticMovements != null) {
            this.staticMovements.move(this);
        }
        this.context.apply(pose);
        pose.m_85837_((double)x, (double)y, (double)z);
        for (String key : this.bones.keySet()) {
            this.bones.get(key).shouldUseParentPose(true);
            this.bones.get(key).render(pose, source, x, y, z, light, overlay);
        }
        pose.m_85849_();
        if (shouldPush) {
            pose.m_85836_();
            pose.m_166854_(lastMatrix);
        }
    }

    @Override
    public MultiPartModel clone() {
        MultiPartModel multiPartModel = new MultiPartModel(String.valueOf(this.key.toCharArray()));
        for (SimpleModel model1 : this.bones.values()) {
            multiPartModel.addBone(model1.clone());
        }
        return multiPartModel;
    }

    public static interface StaticMovements {
        public void move(MultiPartModel var1);
    }
}

