/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture;

import java.util.function.Supplier;

public class Matrix<T> {
    private final Object[][] matrix;
    private Supplier<T> defaultElement;

    public Matrix(int row, int colum, Supplier<T> defaultElement) {
        this(row, colum);
        this.defaultElement = defaultElement;
    }

    public Matrix(int row, int column) {
        this.matrix = new Object[row][column];
        this.defaultElement = () -> null;
    }

    public Matrix(int a) {
        this.matrix = new Object[a][a];
        this.defaultElement = () -> null;
    }

    public Matrix(int a, Supplier<T> defaultElement) {
        this(a);
        this.defaultElement = defaultElement;
    }

    public Supplier<T> getDefaultElement() {
        return this.defaultElement;
    }

    public void setDefaultElement(Supplier<T> defaultElement) {
        this.defaultElement = defaultElement;
    }

    public T get(int row, int column) {
        if (this.matrix[row - 1][column - 1] == null) {
            return this.defaultElement.get();
        }
        return (T)this.matrix[row - 1][column - 1];
    }

    public void set(int row, int column, T element) {
        this.matrix[row - 1][column - 1] = element;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("matrix<").append(this.matrix.length).append('*').append(this.matrix[0].length).append('>').append('\n');
        for (Object[] vector : this.matrix) {
            builder.append('|');
            for (Object obj : vector) {
                builder.append(' ').append(obj).append(' ');
            }
            builder.append('|').append('\n');
        }
        return builder.toString();
    }
}

