/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.FutureTask;
import java.util.function.Function;
import java.util.function.Supplier;
import kasuga.lib.core.javascript.ContextModuleLoader;
import kasuga.lib.core.javascript.JavascriptThread;
import kasuga.lib.core.javascript.RequireFunction;
import kasuga.lib.core.javascript.SideEffectContext;
import kasuga.lib.core.javascript.Tickable;
import kasuga.lib.core.javascript.module.JavascriptModule;
import kasuga.lib.core.javascript.module.JavascriptModuleScope;
import kasuga.lib.core.javascript.module.ModuleLoadException;
import kasuga.lib.core.util.Callback;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Context;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Engine;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.HostAccess;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Source;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Value;
import net.minecraft.Util;

public class JavascriptContext {
    Context context;
    Engine engine;
    JavascriptThread thread;
    String name;
    ContextModuleLoader moduleLoader;
    public JavascriptModule rootModule = new JavascriptModule(this);
    SideEffectContext effect = new SideEffectContext();
    HashMap<String, Object> environment = new HashMap();
    public Function<JavascriptModule, RequireFunction> requireFunction = Util.m_143827_(source -> target -> this.moduleLoader.load((JavascriptModule)source, target).orElseThrow(() -> new ModuleLoadException(target, "failed to locate module.")).get());
    Set<Tickable> tickables = new HashSet<Tickable>();

    JavascriptContext(String name, JavascriptThread thread) {
        this.thread = thread;
        this.name = name;
        String path = UUID.randomUUID().toString();
        this.engine = Engine.newBuilder("js").option("inspect", "localhost:4242").option("inspect.Path", path).option("inspect.Suspend", "false").build();
        this.context = Context.newBuilder(new String[0]).allowHostAccess(HostAccess.SCOPED).engine(this.engine).build();
        Value globalThis = this.context.getBindings("js");
        globalThis.putMember("require", this.getRequireFunction());
        this.moduleLoader = new ContextModuleLoader(thread.getModuleLoader());
        this.requireModule("@kasugalib/core").ifPresent(JavascriptModule::get);
    }

    public FutureTask<Value> execute(Supplier<Source> sourceSupplier) {
        FutureTask<Value> task = new FutureTask<Value>(() -> this.context.eval((Source)sourceSupplier.get()));
        this.thread.recordCall(task);
        return task;
    }

    public Value execute(Source source) {
        return this.context.eval(source);
    }

    public Value eval(String code) {
        return this.context.eval("js", code);
    }

    public RequireFunction getRequireFunction(JavascriptModule source) {
        return this.requireFunction.apply(source);
    }

    public RequireFunction getRequireFunction() {
        return this.getRequireFunction(this.rootModule);
    }

    public JavascriptModuleScope getScope() {
        return this.moduleLoader.scope;
    }

    public void close() {
        this.effect.close();
    }

    public void tick() {
        this.tickables.forEach(Tickable::tick);
    }

    public Callback registerTickable(Tickable tickable) {
        if (this.tickables.contains(tickable)) {
            return Callback.nop();
        }
        return this.effect.effect(() -> {
            this.tickables.add(tickable);
            return () -> this.tickables.remove(tickable);
        });
    }

    public Callback collectEffect(Callback callback) {
        return this.effect.collect(callback);
    }

    public HashMap<String, Object> getEnvironment() {
        return this.environment;
    }

    public Callback runTask(Callback task) {
        return this.effect.effect(() -> {
            Runnable finalTask = task::execute;
            this.thread.recordCall(finalTask);
            return () -> this.thread.revokeCall(finalTask);
        });
    }

    public Optional<JavascriptModule> requireModule(String name) {
        return this.moduleLoader.load(this.rootModule, name);
    }
}

