/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript;

import java.util.HashMap;
import java.util.Map;
import kasuga.lib.core.javascript.ContextModuleLoader;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.JavascriptThreadGroup;
import kasuga.lib.core.javascript.SynchronizedThread;

public class JavascriptThread
extends SynchronizedThread {
    private final JavascriptThreadGroup threadGroup;
    ContextModuleLoader moduleLoader;
    private final Map<Object, JavascriptContext> contexts = new HashMap<Object, JavascriptContext>();

    public JavascriptThread(JavascriptThreadGroup javascriptThreadGroup, Object target, String description) {
        super("Javascript Thread - " + description);
        this.threadGroup = javascriptThreadGroup;
        this.moduleLoader = new ContextModuleLoader(javascriptThreadGroup.getModuleLoader());
    }

    @Override
    protected void tick() {
        this.contexts.values().forEach(JavascriptContext::tick);
    }

    @Override
    protected void beforeStop() {
        this.contexts.values().forEach(JavascriptContext::close);
        this.threadGroup.onTerminate(this);
    }

    public ContextModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public JavascriptContext createContext(Object target, String name) {
        return this.contexts.computeIfAbsent(target, o -> new JavascriptContext(name, this));
    }

    public void closeContext(Object obj) {
        JavascriptContext context = this.contexts.remove(obj);
        if (context != null) {
            context.close();
        }
    }
}

