/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.prebuilt.registry;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.ffi.ResourceLocationFFIHelper;
import kasuga.lib.core.javascript.registration.JavascriptPriorityRegistry;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.HostAccess;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Value;
import net.minecraft.resources.ResourceLocation;

public class RegistryProxy<T>
implements Closeable {
    private final JavascriptContext context;
    JavascriptPriorityRegistry<T> target;
    Set<Pair<T, ResourceLocation>> registeredItems = new HashSet<Pair<T, ResourceLocation>>();

    RegistryProxy(JavascriptContext context, JavascriptPriorityRegistry<T> target) {
        this.context = context;
        this.target = target;
    }

    public void register(ResourceLocation location, T item) {
        this.registeredItems.add(Pair.of(item, location));
        this.target.register(this.context, location, item);
    }

    public void unregister(ResourceLocation location, T item) {
        this.registeredItems.remove(Pair.of(item, location));
        this.target.unregister(this.context, location, item);
    }

    @Override
    public void close() {
        for (Pair<T, ResourceLocation> registeredItem : this.registeredItems) {
            this.target.unregister(this.context, registeredItem.getSecond(), registeredItem.getFirst());
        }
        this.registeredItems.clear();
    }

    @HostAccess.Export
    public void register(Value location, Value item) {
        ResourceLocation resourceLocation = ResourceLocationFFIHelper.fromValue(location);
        T localItem = this.target.fromValue(item);
        this.register(resourceLocation, localItem);
    }
}

